/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.tasks.Xmi2ExmiTask;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETest;
import java.io.File;
import java.io.FileFilter;

public class Xmi2ExmiTest
extends E2ETest {
    public void doTest() throws Exception {
        File umlFolder = (File)this.getSource("umlFolder").getValue();
        Xmi2ExmiTest.assertTrue((String)("Uml directory '" + umlFolder.getAbsolutePath() + "' does not exists"), (boolean)umlFolder.exists());
        CompilerConstants.setProjectValue((String)"uml", (String)umlFolder.getAbsolutePath());
        this.buildXmi2Exmi(umlFolder);
    }

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    private void buildXmi2Exmi(File umlFolder) {
        File[] umlFiles = FileUtilities.getFileList((File)umlFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".xml") || file.getName().endsWith(".xml.zip");
            }
        }, (boolean)true);
        Xmi2ExmiTest.assertFalse((String)"No source files found.", (umlFiles.length == 0 ? 1 : 0) != 0);
        File destination = (File)this.getSource("destination").getValue();
        destination.delete();
        destination.mkdirs();
        File projectFolder = new File(E2EBuilderProject.locateProjectHome((File)umlFolder));
        UmlDocumentCompilerSettings settings = new UmlDocumentCompilerSettings(projectFolder);
        settings.setUmlSourceFolder(umlFolder);
        settings.setWorkFolder(destination);
        UmlDocumentFactory factory = new UmlDocumentFactory(settings);
        for (File umlFile : umlFiles) {
            UmlDocument document = new UmlDocument(umlFile, FileUtilities.getRelativePath((File)umlFile, (File)umlFolder).replace(File.separatorChar, '.'), factory);
            Xmi2ExmiTask task = new Xmi2ExmiTask();
            task.setUmlDocument(document);
            try {
                task.execute();
            }
            catch (BuildErrorException buildErrorException) {
                // empty catch block
            }
        }
    }
}

