/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.fife.ui.hex.swing.ByteArrayTransferable;
import org.fife.ui.hex.swing.HexEditor;

class HexEditorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    HexEditorTransferHandler() {
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        HexEditor hexEditor = (HexEditor)jComponent;
        if (!hexEditor.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(dataFlavorArray, hexEditor) != null;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        HexEditor hexEditor = (HexEditor)jComponent;
        int n = hexEditor.getSmallestSelectionIndex();
        int n2 = hexEditor.getLargestSelectionIndex();
        byte[] byArray = new byte[n2 - n + 1];
        for (int i = n2; i >= n; --i) {
            byArray[i - n] = hexEditor.getByte(i);
        }
        ByteArrayTransferable byteArrayTransferable = new ByteArrayTransferable(n, byArray);
        return byteArrayTransferable;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            ByteArrayTransferable byteArrayTransferable = (ByteArrayTransferable)transferable;
            int n2 = byteArrayTransferable.getOffset();
            HexEditor hexEditor = (HexEditor)jComponent;
            hexEditor.removeBytes(n2, byteArrayTransferable.getLength());
        }
    }

    private DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, HexEditor hexEditor) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
            return dataFlavorArray[i];
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        HexEditor hexEditor = (HexEditor)jComponent;
        return hexEditor.isEnabled() ? 3 : 1;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        HexEditor hexEditor = (HexEditor)jComponent;
        boolean bl = false;
        DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), hexEditor);
        if (dataFlavor != null) {
            try {
                Object object = transferable.getTransferData(dataFlavor);
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    String string = (String)object;
                    byte[] byArray = string.getBytes();
                    hexEditor.replaceSelection(byArray);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }
}

