/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks.xuml;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.document.json.xuml.XumlAppliedStereotype;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.document.json.xuml.component.XumlComponent;
import ch.e2e.builder.compiler.document.json.xuml.component.XumlComponents;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

public class DevXumlPortsTask
extends CacheAbleTask
implements JsonDocumentSource {
    public static final String TASK_ID = "dev.xuml.ports.xml";
    private static final Map<String, String[]> STEREOTYPE_PORT_TAGS = new HashMap<String, String[]>();
    private List<String> apiFileNames;
    private JsonDocument jsonDocument;

    public static Boolean select(String id) {
        return id.matches(TASK_ID);
    }

    public DevXumlPortsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Files.project_xml);
        this.apiFileNames = this.collectApiFileNames();
        result.addAll(this.apiFileNames);
        return result;
    }

    private List<String> collectApiFileNames() {
        String[] apiJsonFileNames = new File(this.getSourceManager().getProjectFolder(), Folders.api).list((dir, name) -> name.endsWith(Extensions._api_json));
        if (apiJsonFileNames != null) {
            return Arrays.stream(apiJsonFileNames).map(DevXumlPortsTask::getApiName).map(Files::api__APINAME__APINAME_components_xml).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String getApiName(String fileName) {
        return fileName.replace(Extensions._api_json, "");
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.jsonDocument = new Result(this.collectPorts());
        JaxbUtils.marshalXml((Object)this.jsonDocument, this.getDestinationFile());
    }

    private List<Integer> collectPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.collectProjectPorts());
        ports.addAll(this.collectApiPorts());
        return ports;
    }

    private List<Integer> collectProjectPorts() {
        XumlProject project = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(project.getServicePort());
        ports.add(project.getControlPort());
        return ports;
    }

    private List<Integer> collectApiPorts() {
        ArrayList<Integer> apiPorts = new ArrayList<Integer>();
        for (String apiFileName : this.apiFileNames) {
            XumlComponents xumlComponents = ((JsonDocumentSource)this.getSourceManager().getSource(apiFileName)).getJsonDocument(XumlComponents.class);
            for (XumlComponent component : xumlComponents.getComponent()) {
                for (XumlAppliedStereotype stereotype : component.getAppliedStereotypes()) {
                    apiPorts.addAll(DevXumlPortsTask.getApiPorts(stereotype));
                }
            }
        }
        return apiPorts;
    }

    private static List<Integer> getApiPorts(XumlAppliedStereotype stereotype) {
        String[] tags = STEREOTYPE_PORT_TAGS.get(stereotype.getStereotype());
        if (tags != null) {
            ArrayList<Integer> ports = new ArrayList<Integer>(tags.length);
            for (String tag : tags) {
                Object port = stereotype.getSimpleTagValue(tag, null);
                if (port == null) continue;
                try {
                    ports.add(Integer.valueOf(port.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return ports;
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            try {
                this.jsonDocument = (JsonDocument)JaxbUtils.unmarshalXml(this.getFile(), type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)this.jsonDocument;
    }

    static {
        STEREOTYPE_PORT_TAGS.put("E2ERESTService", new String[]{"port", "tracePort"});
    }

    @XmlRootElement
    public static class Result
    implements JsonDocument {
        @XmlElementWrapper
        @XmlElement(name="port")
        private List<Integer> ports;

        public Result(List<Integer> ports) {
            this.ports = ports;
        }

        public Result() {
        }

        public List<Integer> getPorts() {
            return this.ports == null ? Collections.emptyList() : Collections.unmodifiableList(this.ports);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.getPorts().equals(((Result)o).getPorts());
        }

        public int hashCode() {
            return this.getPorts().hashCode();
        }
    }
}

