/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.common.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.error.TaskError;
import ch.e2e.builder.compiler.build.tasks.rest.RestTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerResponse;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerType;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.scheer.pas.compiler.dev.api.DevStartEnvironment;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class DevTask
extends RestTask {
    public DevTask(SourceManager sourceManager, String id, Client client) {
        super(sourceManager, id, client);
    }

    @Override
    protected Entity<?> getEntity() {
        return Entity.json((Object)"{}");
    }

    @Override
    protected void handleResponse(Response response) {
        block6: {
            try {
                Path file = this.getDestinationFile().toPath();
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (Files.notExists(file, new LinkOption[0])) {
                    Files.createFile(file, new FileAttribute[0]);
                }
                Files.write(file, new Date().toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
                if (this.isSuccessful(response)) break block6;
                final Response.StatusType statusInfo = response.getStatusInfo();
                int statusCode = statusInfo.getStatusCode();
                String statusMessage = statusInfo.getReasonPhrase();
                if (response.hasEntity() && response.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                    try {
                        JsonNode entity = (JsonNode)response.readEntity(JsonNode.class);
                        statusCode = entity.get("statusCode").asInt();
                        statusMessage = entity.get("message").asText();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.getErrorHandler().error((AbstractBuilderError)new TaskError("DEVSTACK0001", (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("code", String.valueOf(statusInfo.getStatusCode()));
                        this.put("taskId", DevTask.this.getId());
                    }
                }));
                Logging.logger.warning(String.format("%s - Error sending request to '%s/%s' - (%d - %s)", this.getId(), this.getBaseUrl(), this.getActionPath(), statusCode, statusMessage));
            }
            catch (Exception e) {
                Logging.logger.warning(String.format("%s - Exception in task: %s", this.getId(), e.getMessage()));
            }
        }
    }

    @Override
    public boolean isUpToDate() {
        return super.isUpToDate() && !this.getErrorHandler().hasErrors();
    }

    public DevContainerResponse getDevContainer(DevContainerType type) {
        DevStartEnvironment.Result devEnvResult = ((JsonDocumentSource)this.getSourceManager().getSource("dev.start.environment")).getJsonDocument(DevStartEnvironment.Result.class);
        DevStackResponse devStack = devEnvResult.getDevStackResponse();
        return devStack.getContainers().stream().filter(devContainer -> devContainer.getType() == type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Dev stack '%s' contains no container of type '%s'", new Object[]{devStack.getId(), type})));
    }

    public String getDevServicePath(DevContainerResponse devContainer) {
        return String.format("http://%s:%s", devContainer.getHostname(), devContainer.getPort());
    }

    protected boolean isSuccessful(Response response) {
        return response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL);
    }
}

