/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks.clean;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import com.scheer.pas.compiler.angular.v13.tasks.clean.AngularCleanWorkspaceTask;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AngularTaskProjectCleanTask
extends AngularCleanWorkspaceTask {
    public static Boolean select(String id) {
        return id.endsWith(com.scheer.pas.compiler.angular.v13.constants.Files.angular__task_clean);
    }

    public AngularTaskProjectCleanTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.addAll(this.getBpmnIds());
        return super.getSourceSet();
    }

    @Override
    protected Set<String> getProjectDirectories() {
        return this.getBpmnFileNames().stream().map(bpmnName -> AngularVersion.basePath_ + Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks(this.getAngularProjectName(), bpmnName)).collect(Collectors.toSet());
    }

    @Override
    protected Set<String> getUpToDateProjects() throws Exception {
        HashSet<String> result = new HashSet<String>();
        this.getBpmnIds().forEach(id -> {
            BpmnDefinitions bpmnDefinitions = ((JsonDocumentSource)this.getSourceManager().getSource((String)id)).getJsonDocument(BpmnDefinitions.class);
            if (bpmnDefinitions != null && bpmnDefinitions.getProcess() != null) {
                bpmnDefinitions.getProcess().forEach(bpmnProcess -> {
                    if (bpmnProcess.getUserTask() != null) {
                        bpmnProcess.getUserTask().forEach(bpmnUserTask -> {
                            if (bpmnUserTask.getExtensionElements() != null && bpmnUserTask.getExtensionElements().getForm() != null && bpmnUserTask.getExtensionElements().getForm().getForm() != null && !bpmnUserTask.getExtensionElements().getForm().getForm().equals("")) {
                                result.add(AngularVersion.basePath_ + Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(this.getAngularProjectName(), bpmnProcess.getName(), bpmnUserTask.getName()));
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    private Set<String> getBpmnFileNames() {
        try {
            return Files.walk(this.getSourceManager().getProjectFolder().toPath().resolve(Folders.bpmn), new FileVisitOption[0]).map(Path::getFileName).map(Path::toString).filter(fileName -> fileName.endsWith(Extensions._bpmn_json)).map(bpmn -> bpmn.replace(Extensions._bpmn_json, "")).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private Set<String> getBpmnIds() {
        return this.getBpmnFileNames().stream().map(ch.e2e.builder.compiler.build.tasks.constants.Files::bpmn__PROCESS_bpmn_xml).collect(Collectors.toSet());
    }
}

