/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.base.libraries;

import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.angular.base.document.json.XumlApp;
import com.scheer.pas.compiler.angular.core.AngularHelper;
import com.scheer.pas.compiler.angular.core.constants.Extensions;
import com.scheer.pas.compiler.angular.core.constants.Files;
import com.scheer.pas.compiler.angular.core.constants.Folders;
import com.scheer.pas.compiler.xuml.api.tasks.libraries.LibraryItemType;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;

public class TgzLibraryItemType
extends LibraryItemType {
    @Override
    public List<String> getUnzipTargetPaths(ZipEntry zipEntry, SourceManager sourceManager) {
        if (zipEntry.getName().endsWith(Extensions._tgz)) {
            XumlApp app = sourceManager.getSource(Files.app_xml, JsonDocumentSource.class).getJsonDocument(XumlApp.class);
            return Arrays.asList(Folders.angular_vVERSION_(app.getAngularVersion()) + Folders.angular_libraries + Folders.SEPARATOR + zipEntry.getName(), Folders.angular_vVERSION_(app.getAngularVersion()) + Folders.angularLib_libraries + Folders.SEPARATOR + zipEntry.getName());
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getUnzipSourceSet(SourceManager sourceManager) {
        return new HashSet<String>(Collections.singleton(Files.app_xml));
    }

    @Override
    public boolean isAllowedInXlib(String id) {
        return id.endsWith(Extensions._tgz);
    }

    @Override
    public Set<String> getXlibZipBeforeSourceSet(SourceManager sourceManager) {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(Files.project_xml);
        sourceSet.addAll(FormHelper.getFormJsonDocumentSourceSet(sourceManager));
        return sourceSet;
    }

    @Override
    public Set<String> getXlibZipSourceSet(SourceManager sourceManager) {
        Set<String> exposedForms = FormHelper.getLibraryForms(sourceManager);
        if (!exposedForms.isEmpty()) {
            return new HashSet<String>(Collections.singleton(this.getArchivePath(this.getProject(sourceManager))));
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, File> getXlibZipInputFiles(SourceManager sourceManager) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        Set<String> exposedForms = FormHelper.getLibraryForms(sourceManager);
        if (!exposedForms.isEmpty()) {
            XumlProject project = this.getProject(sourceManager);
            String angularLibArchiveName = AngularHelper.getAngularLibArchiveName(project);
            fileMap.put(angularLibArchiveName, new File(sourceManager.getWorkFolder(), this.getArchivePath(project)));
        }
        return fileMap;
    }

    @Override
    public Set<String> getLibraryDescriptorBeforeSourceSet(SourceManager sourceManager) {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(Files.project_xml);
        sourceSet.addAll(FormHelper.getFormJsonDocumentSourceSet(sourceManager));
        return sourceSet;
    }

    @Override
    public Set<String> getLibraryDescriptorSourceSet(SourceManager sourceManager) {
        Set<String> exposedForms = FormHelper.getLibraryForms(sourceManager);
        if (!exposedForms.isEmpty()) {
            return new HashSet<String>(Collections.singleton(Files.angular__angular_libraryDescriptorContent_json));
        }
        return Collections.emptySet();
    }

    private XumlProject getProject(SourceManager sourceManager) {
        return ((JsonDocumentSource)sourceManager.getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
    }

    private String getArchivePath(XumlProject project) {
        String angularLibArchiveName = AngularHelper.getAngularLibArchiveName(project);
        return Folders.angular_ + Folders.angularLib_dist_ + AngularHelper.getAngularLibName(project.getName()) + Folders.SEPARATOR + angularLibArchiveName;
    }
}

