/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.utils;

public class StringUtils {
    public static String substringBefore(String searchString, String stringToSearch) {
        int index = searchString.indexOf(stringToSearch);
        if (index > 0) {
            return searchString.substring(0, index);
        }
        return searchString;
    }

    public static String substringAfter(String searchString, String stringToSearch) {
        int index = searchString.indexOf(stringToSearch);
        if (index >= 0 && index + stringToSearch.length() < searchString.length()) {
            return searchString.substring(index + stringToSearch.length());
        }
        return "";
    }

    public static String substringBetween(String searchString, String startString, String endString) {
        return StringUtils.substringBefore(StringUtils.substringAfter(searchString, startString), endString);
    }

    public static String filterUnprintableChars(String string) {
        return string.codePoints().filter(c -> {
            switch (Character.getType(c)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    return false;
                }
            }
            return true;
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

