/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildRemovedEvent;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DependencySupplier;
import ch.e2e.builder.compiler.uml.DependencySupplierDefinition;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Logging;
import ch.e2e.builder.compiler.uml.NullValue;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeploymentElement
extends UmlElement {
    private static UndefinedArtifact undefinedArtifact;
    private ClassifierElement classifier;
    private String manifestationID;
    private boolean selectable;
    private boolean bindClassifierName = false;

    public DeploymentElement(ClassifierElement classifier, Helpers helpers) {
        this(StringTools.replaceProperty((String)(classifier.getStereotype().getDeploymentType() == null ? classifier.getStereotype().getCustomization().getElementName().getDefault() : classifier.getStereotype().getDeploymentType().getCustomization().getElementName().getDefault()), (String)"classifier name", (String)classifier.getName()), classifier, helpers);
    }

    public DeploymentElement(String name, ClassifierElement classifier, Helpers helpers) {
        this(name, new Comment(classifier.getStereotype().getDeploymentType() == null ? classifier.getStereotype().getCustomization().getElementDescription().getDefault() : classifier.getStereotype().getDeploymentType().getCustomization().getElementDescription().getDefault(), helpers), classifier, helpers);
    }

    public DeploymentElement(String name, Comment description, ClassifierElement classifier, Helpers helpers) {
        this(name, description, classifier.getStereotype().getDeploymentType(), helpers);
        this.classifier = classifier;
        for (BridgeStereotype stereotype : classifier.getStereotypes()) {
            if (stereotype.getDeploymentType() == null) continue;
            this.addStereotype(stereotype.getDeploymentType());
        }
    }

    public DeploymentElement(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
        this.selectable = false;
    }

    public DeploymentElement(BridgeStereotype stereotype, Helpers helpers) {
        super(stereotype, helpers);
    }

    public DeploymentElement(String name, Comment description, Helpers helpers) {
        this(name, description, (BridgeStereotype)null, helpers);
    }

    @Override
    public void setName(String name) {
        if (this.bindClassifierName) {
            this.classifier.setName(this.findClassifierName(name));
        }
        super.setName(name);
    }

    public DeploymentElement findDeploymentElement(UmlElement classifier) {
        DeploymentElement result = null;
        List<UmlElement> children = this.getChildren();
        for (UmlElement child : children) {
            DeploymentElement deploymentElement = (DeploymentElement)child;
            if (deploymentElement.getClassifier().equals(classifier)) {
                result = deploymentElement;
                continue;
            }
            result = deploymentElement.findDeploymentElement(classifier);
        }
        return result;
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getElementHelper().createArtifactReference(this);
    }

    public void setBindClassifierName(boolean bindClassifierName) {
        this.bindClassifierName = bindClassifierName;
    }

    @Override
    public void removeChild(UmlElement child) {
        super.removeChild(child);
        if (child instanceof DeploymentElement) {
            child.setChildListener(null);
            if (this.getChildListener() != null) {
                this.getChildListener().childRemoved(new ChildRemovedEvent(this, (DeploymentElement)child, this));
            }
        }
    }

    public ClassifierElement getClassifier() {
        return this.classifier;
    }

    public void setClassifier(ClassifierElement classifier) {
        this.classifier = classifier;
    }

    @Override
    public boolean isComplete() {
        try {
            boolean complete;
            boolean bl = complete = (Boolean)this.getStereotype().getCustomization().getProperty("childRequired") == false;
            if (!complete) {
                List<UmlElement> children = this.getChildren();
                int length = children.size();
                complete = length > 0;
                for (int i = 0; i < length && complete; ++i) {
                    complete = children.get(i).isComplete();
                }
            }
            return complete;
        }
        catch (NullPointerException e) {
            Logging.logger.severe("Property childRequired is not defined for " + this.getStereotype().getName());
            return false;
        }
    }

    @Override
    public boolean isSelectable() {
        return this.selectable || this.getStereotype().getCustomization().getChildren().size() > 0 && this.isChildSelectionEnabled();
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public ArrayList<DependencySupplierDefinition> findRequiredSupplierTypes() {
        ArrayList<DependencySupplierDefinition> result = new ArrayList<DependencySupplierDefinition>();
        Iterator<BridgeStereotype> dependencies = this.getStereotype().getCustomization().getRequiredBridgeDependencies().iterator();
        while (dependencies.hasNext() && result.size() == 0) {
            BridgeStereotype dependency = dependencies.next();
            if (this.containsDependency(dependency)) continue;
            result.addAll(((DependencyCustomization)dependency.getCustomization()).getSupplierDefinitions());
        }
        Iterator<UmlElement> children = this.getChildren().iterator();
        while (children.hasNext() && result.size() == 0) {
            result = ((DeploymentElement)children.next()).findRequiredSupplierTypes();
        }
        return result;
    }

    public BridgeStereotype findRequiredNodeType() {
        BridgeStereotype result = null;
        Iterator<BridgeStereotype> dependencies = this.getStereotype().getCustomization().getRequiredBridgeDependencies().iterator();
        while (dependencies.hasNext() && result == null) {
            ArrayList<BridgeStereotype> nodeTypes;
            BridgeStereotype dependency = dependencies.next();
            if (this.containsDependency(dependency) || (nodeTypes = ((DependencyCustomization)dependency.getCustomization()).getSupplierNodeTypes()).size() <= 0) continue;
            result = nodeTypes.get(0);
        }
        Iterator<UmlElement> children = this.getChildren().iterator();
        while (children.hasNext() && result == null) {
            result = ((DeploymentElement)children.next()).findRequiredNodeType();
        }
        return result;
    }

    @Override
    public BridgeStereotype getChildBridgeStereotype(String stereotype) {
        BridgeStereotype result = null;
        if (this.getStereotype() != null) {
            ArrayList<BridgeStereotype> children = this.getStereotype().getCustomization().getChildren();
            int length = children.size();
            for (int i = 0; i < length && result == null; ++i) {
                BridgeStereotype bridgeStereotype = children.get(i);
                if (bridgeStereotype.getDeploymentType() == null || !bridgeStereotype.getDeploymentType().getName().equals(stereotype)) continue;
                result = bridgeStereotype.getDeploymentType();
            }
        }
        return result;
    }

    @Override
    public boolean containsChildOfType(ClassifierElement classifierElement) {
        boolean result = false;
        int length = this.getChildren().size();
        for (int i = 0; i < length && !result; ++i) {
            DeploymentElement child = (DeploymentElement)this.getChildren().get(i);
            result = child.getClassifier().equals(classifierElement);
        }
        return result;
    }

    @Override
    public boolean containsChildOfType(BridgeStereotype stereotype) {
        boolean result = false;
        int length = this.getChildren().size();
        for (int i = 0; i < length && !result; ++i) {
            result = this.getChildren().get(i).getStereotype().equals(stereotype);
        }
        return result;
    }

    public String getManifestationID() {
        if (this.manifestationID == null || this.manifestationID.length() == 0) {
            this.manifestationID = "manifestation_" + this.getXmiID();
        }
        return this.manifestationID;
    }

    public void setManifestationID(String manifestationID) {
        this.manifestationID = manifestationID;
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        this.addClassifierDependency(ownerDocument, result, xmiIDFactory);
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element nestedArtifact = this.createNestedArtifactChild(ownerDocument, xmiIDFactory);
        this.addClassifierDependency(ownerDocument, nestedArtifact, xmiIDFactory);
        return nestedArtifact;
    }

    public void findExistingSuppliers(ArrayList<DependencySupplierDefinition> dependencySuppliers, ArrayList<DependencySupplier> suppliers, ArrayList<UmlElement> addedSuppliers) {
        for (UmlElement child : this.getChildren()) {
            for (DependencySupplierDefinition definition : dependencySuppliers) {
                if (!definition.getSupplier().equals(child.getStereotype()) || addedSuppliers.contains(child)) continue;
                suppliers.add(new DependencySupplier((DeploymentElement)child));
                addedSuppliers.add(child);
            }
            ((DeploymentElement)child).findExistingSuppliers(dependencySuppliers, suppliers, addedSuppliers);
        }
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return false;
    }

    @Override
    public UmlElement createCopy() {
        UmlElement result = super.createCopy();
        this.checkXmiIdAndChildrenOfCopy(((DeploymentElement)result).getClassifier());
        return result;
    }

    @Override
    protected UmlElement createReferenceObject(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        DeploymentElement result;
        if (this.classifier == null) {
            result = new DeploymentElement(this.getName(), this.getDescription(), this.getStereotype(), this.getHelpers());
        } else {
            ClassifierElement classifier = (ClassifierElement)this.classifier.createReference(referenceObjects, parent instanceof DeploymentElement ? ((DeploymentElement)parent).getClassifier() : parent);
            result = new DeploymentElement(this.getName(), this.getDescription(), classifier, this.getHelpers());
        }
        return result;
    }

    @Override
    protected void informChildListener(UmlElement child) {
        if (child instanceof DeploymentElement) {
            super.informChildListener(child);
            this.checkDependencies();
        }
    }

    protected void addClassifierDependency(Document ownerDocument, Element xmiElement, XmiIDFactory xmiIDFactory) {
        if (this.getClassifier() != null) {
            Element manifestation = ownerDocument.createElement("manifestation");
            manifestation.setAttribute("visibility", "public");
            manifestation.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getManifestationID());
            manifestation.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:Manifestation");
            if (this.checkModule(this.getClassifier().getModule())) {
                manifestation.setAttribute("utilizedElement", this.getClassifier().getXmiID());
                Element supplier = ownerDocument.createElement("supplier");
                supplier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getClassifier().getXmiID());
                manifestation.appendChild(supplier);
            } else {
                Element utilizedElement = this.createModuleLink(this.classifier, "utilizedElement", ownerDocument, xmiIDFactory);
                manifestation.appendChild(utilizedElement);
                Element supplier = this.createModuleLink(this.getClassifier(), "supplier", ownerDocument, xmiIDFactory);
                manifestation.appendChild(supplier);
            }
            Element client = ownerDocument.createElement("client");
            client.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
            manifestation.appendChild(client);
            xmiElement.appendChild(manifestation);
        }
    }

    protected List<UmlElement> findAllChildren() {
        return this.getChildren();
    }

    @Override
    protected boolean isChildRequired(BridgeStereotype stereotype) {
        Boolean childRequired = (Boolean)stereotype.getCustomization().getProperty("childRequired");
        return childRequired == null ? false : childRequired;
    }

    private void checkDependencies() {
        for (UmlElement umlElement : this.getChildren()) {
            DeploymentElement child = (DeploymentElement)umlElement;
            child.checkDependencies();
        }
    }

    private String findClassifierName(String name) {
        int index = name.indexOf("Artifact");
        if (index != -1) {
            name = name.substring(0, index) + "Component" + name.substring(index + 8);
        }
        return name;
    }

    public static UndefinedArtifact getUndefinedArtifact(Helpers helpers) {
        if (undefinedArtifact == null) {
            undefinedArtifact = new UndefinedArtifact(helpers);
        }
        return undefinedArtifact;
    }

    public static class UndefinedArtifact
    extends DeploymentElement
    implements NullValue {
        private UndefinedArtifact(Helpers helpers) {
            super("<UNDEFINED>", new Comment("", helpers), helpers);
        }

        @Override
        public String getXmiID() {
            return "---$<UNDEFINED>$---";
        }
    }
}

