/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Keyable;
import ch.e2e.builder.compiler.uml.TypedElement;
import java.util.Collection;

public class ActionParameter
implements TypedElement,
Keyable<String> {
    private String name;
    private Direction direction;
    private BridgeClass type;
    private BridgeClass arrayElementType;
    private String warning;
    private Helpers helpers;

    public ActionParameter(String name, BridgeClass type, BridgeClass arrayElementType, Direction direction, Helpers helpers) {
        this.name = name;
        this.type = type;
        this.arrayElementType = arrayElementType;
        this.direction = direction;
        this.warning = null;
        this.helpers = helpers;
    }

    protected Helpers getHelpers() {
        return this.helpers;
    }

    public ActionParameter(String name, BridgeClass type, Direction direction, Helpers helpers) {
        this(name, type, null, direction, helpers);
    }

    public ActionParameter(String name, Direction direction, Helpers helpers) {
        this(name, null, null, direction, helpers);
    }

    @Override
    public String getKey() {
        return this.name != null && this.name.length() > 0 ? this.name : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public BridgeClass getTypeClass() {
        return this.type;
    }

    @Override
    public void setTypeClass(BridgeClass type) {
        this.type = type;
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        return this.arrayElementType;
    }

    protected void setArrayElementType(BridgeClass arrayElementType) {
        this.arrayElementType = arrayElementType;
    }

    @Override
    public boolean isArray() {
        return this.arrayElementType != null || this.getHelpers().getElementHelper().findType("Base Types/Array").equals(this.type);
    }

    @Override
    public String getSignature() {
        String signature = this.name;
        signature = this.isArray() ? signature + (this.arrayElementType == null ? " : [no type]" : this.arrayElementType.getSignature()) + "[]" : signature + (this.type == null ? " : [no type]" : this.type.getSignature());
        return signature;
    }

    public Collection<TypedElement> getElements() {
        return this.type.getElements();
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }
}

