/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.resource;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.document.importer.resource.Resource;
import ch.e2e.builder.compiler.document.importer.resource.ResourceImportSource;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;

public class ResourceImportTransaction
extends ScriptImportTransaction {
    public static final String RESOURCE_IMPORT_SOURCE = "resource.import.source";
    public static final String RESOURCE_IMPORT_MODEL = "resource.import.model";

    @Override
    public void doTransaction(ImporterData importerData) {
        Document javaDocument = ((ResourceImportSource)importerData.getSource(RESOURCE_IMPORT_SOURCE)).getSourceDocument();
        this.printSourceDocument(javaDocument, importerData.getFilename());
        ImportModel importModel = new ImportModel(importerData.getFilename());
        importModel.setModel(javaDocument);
        importModel.setDataModel(((ResourceImportSource)importerData.getSource(RESOURCE_IMPORT_SOURCE)).getDataModel());
        importerData.addSource(RESOURCE_IMPORT_MODEL, importModel);
    }

    @Override
    public void transactionFinished(ImporterData importerData) {
        this.copyFiles(importerData);
    }

    protected void copyFiles(ImporterData importerData) {
        ResourceImportSource source = (ResourceImportSource)importerData.getSource(RESOURCE_IMPORT_SOURCE);
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        for (Resource resource : source.getResources()) {
            Property property = resource.getStereotype().getProperty("templatesFolder");
            String templatesFolder = (String)property.getValue();
            File destination = new File(new File(projectHome, templatesFolder), resource.getName());
            try {
                FileUtilities.copyFile((File)resource.getResourceFile(), (File)destination);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

