/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.base.event.ShowErrorEvent;
import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.Logging;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlZipDocument;
import ch.e2e.builder.compiler.library.Library;
import ch.e2e.builder.compiler.models.Models;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipFile;

public class UmlDocumentFactory
implements ProjectListener {
    private static final String E2E_BRIDGE_BASE_ID = "E2E_BRIDGE_BASE_COMPONENTS";
    private static final String E2E_BRIDGE_PROFILE_ID = "E2E_BRIDGE_PROFILE";
    private static final String E2E_PROCESS_TRACING_ID = "E2E_PROCESS_TRACING";
    private File idFile;
    private HashMap<String, String> uniqueIds;
    private HashMap<String, UmlDocument> documents = new HashMap();
    private boolean saveChangesDirectly = true;
    private HashMap<String, String> documentNamesMap = new HashMap();
    private UmlDocument bridgeBaseDocument;
    private UmlDocument bridgeProfileDocument;
    private UmlDocument processTracingDocument;
    private UmlDocumentCompilerSettings settings;

    public UmlDocumentFactory(UmlDocumentCompilerSettings settings) {
        this.settings = settings;
        this.loadIds();
        this.saveChangesDirectly = true;
    }

    private static File getModelLibrariesFolder() {
        File res;
        try {
            res = new File(new URL(URLDecoder.decode(System.getProperty("ch.e2e.builder.compiler.model.libraries.url", "."), "UTF-8")).getFile());
        }
        catch (Exception e) {
            res = new File(".");
        }
        return res.getAbsoluteFile();
    }

    private static File getProfilesFolder() {
        File res;
        try {
            res = new File(new URL(URLDecoder.decode(System.getProperty("ch.e2e.builder.compiler.profiles.url", "."), "UTF-8")).getFile());
        }
        catch (Exception e) {
            res = new File(".");
        }
        return res.getAbsoluteFile();
    }

    private static String getApplicationHome() {
        return System.getProperty("install.root", ".").replace(File.separatorChar, '/');
    }

    public UmlDocumentCompilerSettings getSettings() {
        return this.settings;
    }

    public UmlDocument getUmlDocument(File umlFile) {
        String absolutePath = FileUtilities.getAbsolutePath((File)umlFile);
        return this.getUmlDocument(absolutePath, umlFile);
    }

    public UmlDocument getUmlDocument(String absolutePath) {
        File umlFile = new File(absolutePath);
        return this.getUmlDocument(absolutePath, umlFile);
    }

    public UmlDocument getUmlDocumentByName(String name) {
        String id = this.documentNamesMap.get(name);
        if (id != null) {
            return this.getUmlDocumentById(id);
        }
        return this.getUmlDocument(new File(this.settings.getUmlSourceFolder(), name));
    }

    public UmlDocument getUmlDocumentById(String id) {
        UmlDocument umlDocument = this.documents.get(id);
        if (umlDocument == null) {
            String path = this.findPath(id);
            if (path == null) {
                if (id.equals(E2E_BRIDGE_BASE_ID)) {
                    this.findBridgeBaseDocument();
                    return this.bridgeBaseDocument;
                }
                if (id.equals(E2E_BRIDGE_PROFILE_ID)) {
                    this.findBridgeProfileDocument();
                    return this.bridgeProfileDocument;
                }
                if (id.equals(E2E_PROCESS_TRACING_ID)) {
                    this.findProcessTracingDocument();
                    return this.processTracingDocument;
                }
                Logging.logger.fine("No path found for id " + id);
            } else {
                File umlFile = new File(path);
                if (!umlFile.isAbsolute()) {
                    umlFile = new File(this.settings.getUmlSourceFolder(), path);
                }
                umlDocument = this.createDocument(umlFile, id);
            }
        }
        return umlDocument;
    }

    public boolean isInSrcPath(File file) {
        boolean inPath = false;
        for (File folder = file.getParentFile(); folder != null && !inPath; folder = folder.getParentFile()) {
            inPath = folder.equals(this.settings.getUmlSourceFolder());
        }
        return inPath;
    }

    public String getBridgeBaseFileName() {
        if (this.bridgeBaseDocument == null) {
            this.findBridgeBaseDocument();
        }
        return this.bridgeBaseDocument == null ? null : this.bridgeBaseDocument.getOriginalFile().getName();
    }

    public UmlDocument getBridgeBaseDocument() {
        if (this.bridgeBaseDocument == null) {
            this.findBridgeBaseDocument();
        }
        return this.bridgeBaseDocument;
    }

    public String getBridgeProfileFileName() {
        if (this.bridgeProfileDocument == null) {
            this.findBridgeProfileDocument();
        }
        return this.bridgeProfileDocument == null ? null : this.bridgeProfileDocument.getOriginalFile().getName();
    }

    public UmlDocument getBridgeProfileDocument() {
        if (this.bridgeProfileDocument == null) {
            this.findBridgeProfileDocument();
        }
        return this.bridgeProfileDocument;
    }

    public UmlDocument getProcessTracingDocument() {
        if (this.processTracingDocument == null) {
            this.findProcessTracingDocument();
        }
        return this.processTracingDocument;
    }

    private UmlDocument getUmlDocument(String absolutePath, File umlFile) {
        String id;
        UmlDocument umlDocument = null;
        if (this.settings.getUmlSourceFolder() == null) {
            EventController.fire((EventObject)new ShowErrorEvent((Object)this, "No project information found. Have you opened an Scheer PAS Builder project?"));
        } else if (absolutePath.contains("E2E Bridge Base")) {
            umlDocument = this.getBridgeBaseDocument();
        } else if (absolutePath.contains("E2E Bridge Profile")) {
            umlDocument = this.getBridgeProfileDocument();
        } else if (absolutePath.contains("E2E Process Tracing")) {
            umlDocument = this.getProcessTracingDocument();
        } else if (umlFile.exists() && (umlDocument = this.documents.get(id = this.getUniqueId(absolutePath))) == null) {
            umlDocument = this.createDocument(umlFile, id);
        }
        return umlDocument;
    }

    public void remove(UmlDocument document) {
        if (this.documentNamesMap.containsKey(document.getName())) {
            this.documentNamesMap.remove(document.getName());
            String path = this.getPath(document.getAbsolutePath());
            String id = this.uniqueIds.get(path);
            this.documents.remove(id);
            this.uniqueIds.remove(path);
            document.clearAll();
        }
    }

    public void reloadIds(File workingFolder) {
        this.loadIds();
    }

    private void loadIds() {
        File workingFolder = this.settings.getWorkFolder();
        if (this.uniqueIds == null && workingFolder != null) {
            this.idFile = new File(workingFolder, ".xmi.id");
            this.saveChangesDirectly = false;
            if (this.uniqueIds == null) {
                this.uniqueIds = new HashMap();
            } else {
                this.uniqueIds.clear();
            }
            this.documents.clear();
            File idFile = new File(workingFolder, ".xmi.id");
            try {
                HashMap fileIds = UniqueIdService.loadUniqueIds((File)idFile);
                for (String path : fileIds.keySet()) {
                    String value = (String)fileIds.get(path);
                    if (path.contains("E2E Bridge Base")) {
                        this.findBridgeBaseDocument();
                        if (this.bridgeBaseDocument != null) continue;
                        value = E2E_BRIDGE_BASE_ID;
                        this.bridgeBaseDocument = this.createBridgeDocument(path, value);
                        if (this.bridgeBaseDocument == null) continue;
                        this.uniqueIds.put(path.replace(File.separatorChar, '/'), value);
                        continue;
                    }
                    if (path.contains("E2E Bridge Profile")) {
                        this.findBridgeProfileDocument();
                        if (this.bridgeProfileDocument != null) continue;
                        value = E2E_BRIDGE_PROFILE_ID;
                        this.bridgeProfileDocument = this.createBridgeDocument(path, value);
                        if (this.bridgeProfileDocument == null) continue;
                        this.uniqueIds.put(path.replace(File.separatorChar, '/'), value);
                        continue;
                    }
                    if (path.contains("E2E Process Tracing")) {
                        this.findProcessTracingDocument();
                        if (this.processTracingDocument != null) continue;
                        value = E2E_PROCESS_TRACING_ID;
                        this.processTracingDocument = this.createBridgeDocument(path, value);
                        if (this.processTracingDocument == null) continue;
                        this.uniqueIds.put(path.replace(File.separatorChar, '/'), value);
                        continue;
                    }
                    path = this.getPath(path);
                    this.uniqueIds.put(path.replace(File.separatorChar, '/'), value);
                }
            }
            catch (WrongIDFileVersionException e) {
                this.uniqueIds = new HashMap();
                idFile.delete();
                FileUtilities.silentDeleteAll((File)workingFolder);
            }
        }
    }

    private UmlDocument createBridgeDocument(String path, String value) {
        UmlDocument umlDocument = null;
        File bridgeFile = new File(path);
        if (!bridgeFile.isAbsolute()) {
            bridgeFile = new File(this.settings.getUmlSourceFolder(), path);
        }
        String applicationHome = UmlDocumentFactory.getApplicationHome();
        String absolutePath = FileUtilities.getAbsolutePath((File)bridgeFile).replace(File.separatorChar, '/');
        if (bridgeFile.exists() && absolutePath.contains(applicationHome)) {
            umlDocument = this.createDocument(bridgeFile, value);
            this.uniqueIds.put(absolutePath, value);
        } else if (bridgeFile.exists()) {
            UmlDocument tempDocument = this.createUmlDocument(bridgeFile, value);
            tempDocument.getBridgeXmiFile().delete();
        }
        return umlDocument;
    }

    public void deleteUmlDocumentFolders(ArrayList<UmlDocument> umlDocuments) {
        File binariesFolder = this.settings.getBinaryFolder();
        for (UmlDocument umlDocument : umlDocuments) {
            FileUtilities.silentDeleteDirectory((File)umlDocument.getDocumentWorkingFolder());
            FileUtilities.silentDeleteDirectory((File)new File(binariesFolder, umlDocument.getDocumentName()));
            umlDocument.delete();
        }
    }

    public UmlDocument[] getAllDocuments() {
        ArrayList<UmlDocument> documents = new ArrayList<UmlDocument>();
        for (String id : this.uniqueIds.values()) {
            UmlDocument document = this.getUmlDocumentById(id);
            if (document == null) continue;
            documents.add(document);
        }
        UmlDocument[] allDocuments = new UmlDocument[documents.size()];
        documents.toArray(allDocuments);
        return allDocuments;
    }

    private String getUniqueId(String path) {
        String uniqueId = this.uniqueIds.get((path = this.getPath(path)).replace(File.separatorChar, '/'));
        if (uniqueId == null) {
            uniqueId = UniqueIdService.createUniqueId((String)path, this.uniqueIds);
            if (this.saveChangesDirectly) {
                this.saveIds();
            }
        }
        return uniqueId;
    }

    private String getPath(String path) {
        File file = new File(path);
        if (file.isAbsolute() && (path = FileUtilities.getRelativePath((File)file, (File)this.settings.getUmlSourceFolder().getAbsoluteFile())).endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace(File.separatorChar, '/');
    }

    public void saveIds() {
        this.idFile.getParentFile().mkdirs();
        UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
    }

    public void cleanAll() {
        File idFile = new File(this.settings.getWorkFolder(), ".xmi.id");
        idFile.delete();
        this.clear();
    }

    public ArrayList<String> getLibrariesUsingLibrary(Library library) {
        ArrayList<String> result = new ArrayList<String>();
        UmlDocument libraryDocument = this.getUmlDocument(library.getImportModel().getDestination());
        if (libraryDocument != null) {
            for (UmlDocument umlDocument : this.documents.values()) {
                DependsFile dependencies = umlDocument.getDocumentInfo().getDependsFile();
                if (!dependencies.getIncludesFiles().containsKey(libraryDocument.getUniqueId())) continue;
                result.add(umlDocument.getOriginalFile().getName());
            }
        }
        return result;
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
        this.clear();
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
    }

    public void clear() {
        for (UmlDocument umlDocument : this.documents.values()) {
            umlDocument.clearAll();
        }
        if (this.uniqueIds != null) {
            this.uniqueIds.clear();
            this.uniqueIds = null;
        }
        this.documents.clear();
        this.documentNamesMap.clear();
        this.bridgeBaseDocument = null;
        this.bridgeProfileDocument = null;
        this.processTracingDocument = null;
        this.loadIds();
        this.cleanUpReloading();
    }

    public void cleanUpReloading() {
        ArrayList<String> pathsToRemove = new ArrayList<String>();
        for (String path : this.uniqueIds.keySet()) {
            String xmiFileId;
            File umlFile = new File(path);
            if (!umlFile.isAbsolute()) {
                umlFile = new File(this.settings.getUmlSourceFolder(), path);
            }
            if (umlFile.exists() || (xmiFileId = this.uniqueIds.get(path)) == null) continue;
            UmlDocument document = new UmlDocument(umlFile, xmiFileId, this);
            this.deleteUmlDocumentFolders(new ArrayList<UmlDocument>(Arrays.asList(document)));
            pathsToRemove.add(path);
        }
        for (String path : pathsToRemove) {
            this.uniqueIds.remove(path);
        }
        this.saveIds();
        this.saveChangesDirectly = true;
    }

    private UmlDocument createDocument(File umlFile, String id) {
        UmlDocument umlDocument = this.createUmlDocument(umlFile, id);
        if (umlDocument != null) {
            this.documents.put(id, umlDocument);
            this.documentNamesMap.put(umlDocument.getName(), id);
        }
        return umlDocument;
    }

    private UmlDocument createUmlDocument(File umlFile, String id) {
        UmlDocument umlDocument = null;
        if (umlFile.getName().endsWith(".xml.zip") || umlFile.getName().endsWith(".mdzip")) {
            try {
                ZipFile zipFile = new ZipFile(umlFile);
                if (zipFile.size() == 1) {
                    umlDocument = new UmlZipDocument(umlFile, id, this);
                }
            }
            catch (IOException iOException) {}
        } else {
            umlDocument = new UmlDocument(umlFile, id, this);
        }
        return umlDocument;
    }

    private String findPath(String uniqueId) {
        String path = null;
        Iterator<String> paths = this.uniqueIds.keySet().iterator();
        while (paths.hasNext() && path == null) {
            String nextPath = paths.next();
            String id = this.uniqueIds.get(nextPath);
            if (!id.equals(uniqueId)) continue;
            path = nextPath;
        }
        return path;
    }

    private void findBridgeBaseDocument() {
        this.bridgeBaseDocument = this.getModelLibrary("E2E Bridge Base", E2E_BRIDGE_BASE_ID);
    }

    private void findProcessTracingDocument() {
        this.processTracingDocument = this.getModelLibrary("E2E Process Tracing", E2E_PROCESS_TRACING_ID);
    }

    private void findBridgeProfileDocument() {
        this.bridgeProfileDocument = this.getBridgeProfile();
    }

    private UmlDocument getModelLibrary(String fileName, String fileID) {
        UmlDocument result = null;
        File baseFile = UmlDocumentFactory.getBridgeFile(UmlDocumentFactory.getModelLibrariesFolder(), fileName);
        if (baseFile == null || !baseFile.exists() && UmlDocumentFactory.getApplicationHome() != null) {
            BridgeFileFilter baseFileFilter = new BridgeFileFilter(fileName);
            File[] files = FileUtilities.getFileList((String)UmlDocumentFactory.getApplicationHome(), (FileFilter)baseFileFilter, (boolean)true);
            File file = baseFile = files == null || files.length == 0 ? null : files[0];
        }
        if (baseFile != null) {
            result = this.createDocument(baseFile, fileID);
            this.uniqueIds.put(FileUtilities.getAbsolutePath((File)baseFile), fileID);
        }
        return result;
    }

    public static String getGlobalBridgeBaseFileName() {
        File bridgeBase = UmlDocumentFactory.getBridgeFile(UmlDocumentFactory.getModelLibrariesFolder(), "E2E Bridge Base");
        return bridgeBase == null ? "E2E Bridge Base.xml.zip" : bridgeBase.getName();
    }

    public static String getGlobalBridgeProfileFileName() {
        File bridgeProfile = UmlDocumentFactory.getBridgeFile(UmlDocumentFactory.getProfilesFolder(), "E2E Bridge Profile");
        return bridgeProfile == null ? "E2E Bridge Profile.xml.zip" : bridgeProfile.getName();
    }

    private static File getBridgeFile(File folder, String name) {
        File file;
        block8: {
            file = null;
            String filename = name + ".xml";
            try {
                file = new File(folder, filename);
                if (!file.exists()) {
                    file = new File(folder, name + ".xml.zip");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file == null || !file.exists()) {
                URL resourceURL = Models.class.getResource(filename);
                try {
                    file = new File(resourceURL.toURI().normalize()).getAbsoluteFile();
                }
                catch (Exception e) {
                    file = new File(UmlDocumentFactory.getApplicationHome(), filename);
                    if (file.exists()) break block8;
                    try {
                        FileUtilities.copy((InputStream)resourceURL.openStream(), (OutputStream)new FileOutputStream(file), (boolean)true);
                    }
                    catch (IOException e1) {
                        return null;
                    }
                }
            }
        }
        return file;
    }

    private UmlDocument getBridgeProfile() {
        UmlDocument result = null;
        File profileFile = UmlDocumentFactory.getBridgeFile(UmlDocumentFactory.getProfilesFolder(), "E2E Bridge Profile");
        if (profileFile == null || !profileFile.exists()) {
            BridgeFileFilter profileFileFilter = new BridgeFileFilter("E2E Bridge Profile");
            File[] files = FileUtilities.getFileList((String)UmlDocumentFactory.getApplicationHome(), (FileFilter)profileFileFilter, (boolean)true);
            File file = profileFile = files == null || files.length == 0 ? null : files[0];
        }
        if (profileFile != null) {
            result = this.createDocument(profileFile, E2E_BRIDGE_PROFILE_ID);
            this.uniqueIds.put(FileUtilities.getAbsolutePath((File)profileFile), E2E_BRIDGE_PROFILE_ID);
        }
        return result;
    }

    private class BridgeFileFilter
    implements FileFilter {
        private String name;

        public BridgeFileFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().equalsIgnoreCase(this.name + ".xml.zip") || file.getName().equalsIgnoreCase(this.name + ".xml");
        }
    }
}

