/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Element;

public class RepositoryArchiveResource
extends RepositoryResource {
    private boolean extractAll;
    private boolean onlyExtract;
    private boolean flatten;
    private String extractFolder;

    public RepositoryArchiveResource(Element xmlElement, DescriptorElement parent) {
        super(xmlElement, parent);
        this.extractFolder = xmlElement.hasAttribute("extractFolder") ? xmlElement.getAttribute("extractFolder") : "resources/";
        this.setExtractFolder(this.extractFolder);
        this.extractAll = DomUtilities.getBoolean((Element)xmlElement, (String)"extractAll", (boolean)false);
        this.onlyExtract = DomUtilities.getBoolean((Element)xmlElement, (String)"onlyExtract", (boolean)false);
        this.flatten = DomUtilities.getBoolean((Element)xmlElement, (String)"flatten", (boolean)false);
        this.readResources(xmlElement, "Resource");
    }

    @Override
    public Set<String> applyToTargetFiles(Consumer<Map.Entry<String, InputStream>> consumer, AbstractErrorHandler errorHandler) throws IOException {
        HashSet<String> targetFiles;
        block37: {
            targetFiles = new HashSet();
            if (!this.onlyExtract) {
                targetFiles = super.applyToTargetFiles(consumer, errorHandler);
            }
            try (ZipFile source = new ZipFile(this.getTemplateFile());){
                if (this.extractAll || this.onlyExtract) {
                    Enumeration<? extends ZipEntry> entries = source.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory()) continue;
                        String name = entry.getName();
                        if (this.flatten) {
                            name = new File(entry.getName()).getName();
                        }
                        InputStream inputStream = source.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            consumer.accept(new AbstractMap.SimpleEntry<String, InputStream>(this.extractFolder + name, inputStream));
                            targetFiles.add(this.extractFolder + name);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    break block37;
                }
                for (RepositoryResource resource : this.getResources()) {
                    ZipEntry entry = source.getEntry(resource.getName());
                    InputStream inputStream = source.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        consumer.accept(new AbstractMap.SimpleEntry<String, InputStream>(this.extractFolder + resource.getName(), inputStream));
                        targetFiles.add(this.extractFolder + resource.getName());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
        }
        return targetFiles;
    }

    public String getExtractFolder() {
        return this.extractFolder;
    }

    protected void setExtractFolder(String extractFolder) {
        if (!(extractFolder = extractFolder.replace('\\', '/')).endsWith("/")) {
            extractFolder = extractFolder + '/';
        }
        this.extractFolder = extractFolder;
    }
}

