/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.AnnotationNotFoundException;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.model.libraries.AnnotationMetadata;
import ch.e2e.builder.compiler.build.tasks.source.ProjectFileSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.ImportDestination;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.java.ClassLoaderJarfile;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.ImporterJarfile;
import ch.e2e.builder.compiler.document.importer.java.JavaImportSource;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.uml.Helpers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JarSourceFile
extends ProjectFileSource {
    private final SourceManager sourceManager;
    private final ClassLoaderJarfile jarFile = ClassLoaderJarfile.getJarfile(this.getFile());
    private ImporterData importerData;
    private Map<String, AnnotationMetadata> annotations;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._jar);
    }

    public JarSourceFile(File file, SourceManager sourceManager) throws IOException {
        super(file);
        this.sourceManager = sourceManager;
    }

    public Map<String, AnnotationMetadata> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.jarFile.getAnnotatedClassnames();
        }
        return this.annotations;
    }

    public ImporterData getImporterData() throws AnnotationNotFoundException, IOException {
        if (this.importerData == null) {
            this.importerData = this.generateImporterData(this.sourceManager);
        }
        return this.importerData;
    }

    public ImporterData generateImporterData(SourceManager sourceManager) throws IOException, AnnotationNotFoundException {
        JavaImportSource importSource;
        ArrayList<ImporterJarfile> allJarFiles = new ArrayList<ImporterJarfile>(){
            {
                this.add(JarSourceFile.this.jarFile);
            }
        };
        String[] classNames = this.getAnnotations().keySet().toArray(new String[0]);
        if (classNames.length == 0) {
            throw new AnnotationNotFoundException(this.jarFile.getOriginalFile().getName());
        }
        String filename = this.jarFile.getOriginalFile().getName();
        Helpers helpers = new Helpers();
        TypeInfo.reset();
        ImportClassLoader classloader = new ImportClassLoader(helpers);
        classloader.addJarfile(this.jarFile);
        for (String name : classNames) {
            try {
                classloader.loadJavaClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        helpers.getXmiIDFactory().setGlobalPrefix(filename + '_');
        File destinationFile = File.createTempFile(filename, "");
        destinationFile.deleteOnExit();
        ImportDestination destination = new ImportDestination(destinationFile, filename);
        try {
            importSource = new JavaImportSource(this.getFile().getName().replace(Extensions._jar, ""), classloader, true, UmlHelper.getWorkUmlImportsFolder(sourceManager.getWorkFolder()), helpers);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        importSource.addJarfiles((Iterable<? extends ImporterJarfile>)allJarFiles);
        HashMap<String, Object> sources = new HashMap<String, Object>();
        sources.put("java.import.source", importSource);
        sources.put("all.jarfiles", allJarFiles);
        sources.put("jarfile.folder", new File(sourceManager.getWorkFolder(), "jarfiles"));
        sources.put("resources.folder", new File(sourceManager.getWorkFolder(), "resources"));
        return new ImporterData(sources, destination, helpers);
    }
}

