/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.BuildLibraryTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.xuml.api.tasks.libraries.LibraryItemTypeService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LibraryDescriptorTask
extends XSLTTask {
    private final LibraryItemTypeService libraryItemTypeService;
    private Set<String> libraryFormsSourceSet;

    public LibraryDescriptorTask(SourceManager sourceManager, String id, LibraryItemTypeService libraryItemTypeService) {
        super(sourceManager, id);
        this.libraryItemTypeService = libraryItemTypeService;
    }

    private Set<String> getLibraryRepositorySources() {
        return new HashSet<String>(){
            {
                this.add(BuildLibraryTask.TASK_ID);
            }
        };
    }

    private String getBuildID() {
        return this.getLibraryRepositorySources().stream().map(id -> this.getSourceManager().getSource((String)id).getHash()).collect(Collectors.joining("-"));
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._json;
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.library.descriptor";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.addAll(FormHelper.getFormJsonDocumentSourceSet(this.getSourceManager()));
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> result.addAll(itemType.getLibraryDescriptorBeforeSourceSet(this.getSourceManager())));
        return result;
    }

    private Set<String> getLibraryFormsSourceSet() {
        if (this.libraryFormsSourceSet == null) {
            this.libraryFormsSourceSet = FormHelper.getLibraryForms(this.getSourceManager()).stream().map(Files::form__FORM_form_xml).collect(Collectors.toSet());
        }
        return this.libraryFormsSourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Files.project_xml);
        result.addAll(LibrariesHelper.getDescriptorsSourceSet(this.getSourceManager(), false));
        result.addAll(this.getLibraryFormsSourceSet());
        result.addAll(this.getLibraryRepositorySources());
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> result.addAll(itemType.getLibraryDescriptorSourceSet(this.getSourceManager())));
        return result;
    }

    protected XumlProject getProject() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> map = super.getTransformParameters();
        map.put("buildID", this.getBuildID());
        return map;
    }

    public static class Factory
    extends TaskFactory {
        LibraryItemTypeService libraryItemTypeService;

        public Factory(LibraryItemTypeService libraryItemTypeService, Double priority) {
            super(priority);
            this.libraryItemTypeService = libraryItemTypeService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.startsWith(Folders.library_) && id.endsWith(Files.library_descriptor_json);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new LibraryDescriptorTask(sourceManager, id, this.libraryItemTypeService);
        }
    }
}

