/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.FeaturesTabfile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.RepositoryArchiveResource;
import ch.e2e.builder.compiler.descriptor.RepositoryDescriptor;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.builder.compiler.descriptor.ResourceList;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DeploymentDescriptorTask
extends CompileConfigurationTask {
    public DeploymentDescriptorTask() {
        super(new CompileControl[0]);
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        File descriptorFolder = new File(this.getUmlDocument().getDocumentWorkingFolder(), "descriptor");
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            for (Deployment deployment : compilableObject.getDeployments()) {
                Document descriptorDocument = this.createDescriptorDocument(this.getUmlDocument());
                this.addRepositoryConfiguration(descriptorDocument, compilableObject);
                try {
                    Element xmlElement = this.getConfigurationElement(deployment, compilableObject.getName(), descriptorFolder);
                    this.addRuntimeRequirements(descriptorDocument, xmlElement, compilableObject, deployment);
                    Element configurationNode = this.createCompositeNode(xmlElement, descriptorDocument);
                    descriptorDocument.getDocumentElement().appendChild(configurationNode);
                    Element proxyNode = this.createProxyNode(xmlElement, descriptorDocument);
                    descriptorDocument.getDocumentElement().appendChild(proxyNode);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    File descriptorFile = deployment.getDeployFile();
                    if (!descriptorFile.getParentFile().exists()) {
                        descriptorFile.getParentFile().mkdirs();
                    }
                    DomUtilities.serialize((File)descriptorFile, (Document)descriptorDocument, (boolean)true, (ClassLoader)classLoader);
                }
                catch (Exception ex) {
                    Logging.logger.severe("Caught a " + ex.getClass().getName() + ": " + ex.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "executeTask", ex);
                    throw new BuildException(ex);
                }
            }
        }
    }

    public File getTabfileContainer(CompilableObject compilableObject, String deployment) {
        return new File(compilableObject.getUmlDocument().getDocumentWorkingFolder(), deployment + (compilableObject instanceof Composite ? ".composite.tabfiles" : ".library.tabfiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRuntimeRequirements(Document descriptorDocument, Element configurationElement, CompilableObject compilableObject, Deployment deployment) throws Exception {
        File tabfileContainer = this.getTabfileContainer(compilableObject, deployment.getName());
        if (tabfileContainer.exists()) {
            try (ZipFile tabfileZip = new ZipFile(tabfileContainer);){
                ZipEntry featuresEntry = tabfileZip.getEntry("tabfiles/features.tab");
                if (featuresEntry != null) {
                    Document featuresDocument = DomUtilities.parse((InputStream)tabfileZip.getInputStream(featuresEntry), (boolean)false, (boolean)false, (boolean)false);
                    FeaturesTabfile featuresTabfile = new FeaturesTabfile(featuresDocument.getDocumentElement().getTagName(), "features", null);
                    featuresTabfile.appendTable(featuresDocument.getDocumentElement(), configurationElement, compilableObject, null);
                    String recommendedVersion = featuresTabfile.getRecommendedRuntimeVersion();
                    Element runtimeConstraintsElement = descriptorDocument.createElementNS("http://e2e.ch/bridge", "RuntimeConstraints");
                    if (recommendedVersion != null) {
                        runtimeConstraintsElement.setAttribute("recommendedVersion", recommendedVersion);
                    }
                    descriptorDocument.getDocumentElement().appendChild(runtimeConstraintsElement);
                }
            }
        }
    }

    private void addRepositoryConfiguration(Document descriptorDocument, CompilableObject compilableObject) {
        Element configElement = descriptorDocument.createElementNS("http://e2e.ch/bridge", "RepositoryConfiguration");
        Element entries = descriptorDocument.createElementNS("http://e2e.ch/bridge", "RepositoryEntries");
        ArrayList<String> folders = new ArrayList<String>();
        folders.add("tabfiles");
        folders.add("wsdl/");
        folders.add("java");
        folders.add("xslt/");
        folders.add("resources");
        folders.add("htdocs/");
        folders.add("documentation/");
        folders.add("swagger/");
        this.addFolders(compilableObject, folders);
        for (String folder : folders) {
            Element entry = descriptorDocument.createElementNS("http://e2e.ch/bridge", "RepositoryEntry");
            entry.setAttribute("path", folder);
            entries.appendChild(entry);
        }
        configElement.appendChild(entries);
        descriptorDocument.getDocumentElement().appendChild(configElement);
    }

    private void addFolders(CompilableObject compilableObject, ArrayList<String> folders) {
        ResourceList resources = compilableObject.getResources();
        for (RepositoryResource resource : resources) {
            String targetFolder = resource.getTargetFolder();
            if (!targetFolder.endsWith("/")) {
                targetFolder = targetFolder + '/';
            }
            if (folders.contains(targetFolder)) continue;
            folders.add(targetFolder);
            if (!(resource instanceof RepositoryArchiveResource) || folders.contains(((RepositoryArchiveResource)resource).getExtractFolder())) continue;
            folders.add(((RepositoryArchiveResource)resource).getExtractFolder());
        }
        File resourcesHome = this.getUmlDocument().getSettings().getResourceFolder();
        HashMap<String, IncludesFile> includesFiles = this.getUmlDocument().getDocumentInfo().getDependsFile().getIncludesFiles();
        for (IncludesFile file : includesFiles.values()) {
            UmlDocument includeDocument = this.getUmlDocumentFactory().getUmlDocumentById(file.getUmlFileID());
            this.addFolders(resourcesHome, includeDocument.getOriginalFile().getName(), folders);
        }
        this.addFolders(resourcesHome, this.getUmlDocument().getOriginalFile().getName(), folders);
    }

    private void addFolders(File resourcesHome, String filename, ArrayList<String> folders) {
        File[] dirs;
        File modelResourcesFolder = new File(resourcesHome, filename);
        for (File dir : dirs = FileUtilities.getAllDirectories((File)modelResourcesFolder)) {
            String targetFolder = dir.getName();
            if (!targetFolder.endsWith("/")) {
                targetFolder = targetFolder + '/';
            }
            if (folders.contains(targetFolder)) continue;
            folders.add(dir.getName());
        }
    }

    @Override
    protected String getCompilerId() {
        return null;
    }

    private Element createCompositeNode(Element xmlElement, Document descriptorDocument) {
        Element configElement = this.createCompositeNode(descriptorDocument, xmlElement);
        DomUtilities.copyAttributes((Node)xmlElement, (Element)configElement);
        return configElement;
    }

    private Element createCompositeNode(Document descriptorDocument, Element xmlElement) {
        Element configuration = descriptorDocument.createElementNS("http://e2e.ch/bridge", "BridgeConfiguration");
        boolean traceEnabled = XSLTInput.isTraceEnabled();
        configuration.setAttribute("trace", String.valueOf(traceEnabled));
        Element services = descriptorDocument.createElementNS("http://e2e.ch/bridge", "Services");
        NodeList serviceNodes = xmlElement.getElementsByTagName("Service");
        if (serviceNodes != null) {
            int length = serviceNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Boolean shadow;
                Element next = (Element)serviceNodes.item(i);
                boolean appendElement = next.hasAttribute("shadow") ? (shadow = Boolean.valueOf(next.getAttribute("shadow"))) == false | traceEnabled : true;
                if (!appendElement) continue;
                String elementName = "Service";
                this.copyElement(next, services, elementName, descriptorDocument);
            }
        }
        configuration.appendChild(services);
        Element uiDeployments = descriptorDocument.createElementNS("http://e2e.ch/bridge", "UIDeployments");
        NodeList uiNodes = xmlElement.getElementsByTagName("UIDeployment");
        int length = uiNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element next = (Element)uiNodes.item(i);
            Element child = descriptorDocument.createElementNS("http://e2e.ch/bridge", "UIDeployment");
            DomUtilities.copyAttributes((Node)next, (Element)child);
            uiDeployments.appendChild(child);
        }
        configuration.appendChild(uiDeployments);
        return configuration;
    }

    private void copyElement(Element from, Element parent, String elementName, Document descriptorDocument) {
        Element child = descriptorDocument.createElementNS("http://e2e.ch/bridge", elementName);
        DomUtilities.copyAttributes((Node)from, (Element)child);
        this.copyChildren(from, child);
        parent.appendChild(child);
    }

    private void copyChildren(Node from, Element to) {
        NodeList children = from.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element newChild = to.getOwnerDocument().createElementNS("http://e2e.ch/bridge", child.getNodeName());
                to.appendChild(newChild);
                DomUtilities.copyAttributes((Node)child, (Element)newChild);
                this.copyChildren(child, newChild);
                continue;
            }
            if (!(child instanceof Text)) continue;
            to.appendChild(to.getOwnerDocument().createTextNode(child.getNodeValue()));
        }
    }

    private Element createProxyNode(Element xmlElement, Document descriptorDocument) {
        Element configElement = descriptorDocument.createElementNS("http://e2e.ch/bridge", "ProxyConfiguration");
        NodeList nodes = xmlElement.getElementsByTagName("Proxies");
        if (nodes != null) {
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                this.copyElement((Element)nodes.item(i), configElement, "Proxies", descriptorDocument);
            }
        }
        return configElement;
    }

    private Document createDescriptorDocument(UmlDocument umlDocument) {
        Document descriptorDocument = null;
        RepositoryDescriptor configDescriptor = umlDocument.getDescriptor();
        if (configDescriptor != null) {
            Element originalDescriptorDocumentElement;
            descriptorDocument = DomUtilities.newDocument((String)"http://e2e.ch/bridge", (String)"DeploymentDescriptor");
            Element documentElement = descriptorDocument.getDocumentElement();
            documentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://e2e.ch/bridge");
            documentElement.setAttribute("version", configDescriptor.getVersion());
            Document descriptor = configDescriptor.getDescriptorDocument();
            Element originalDocuElement = null;
            if (descriptor != null && (originalDescriptorDocumentElement = descriptor.getDocumentElement()) != null) {
                String xPath = "//Documentation[1]";
                try {
                    Node docuNode = (Node)DomUtilities.evaluate((Node)originalDescriptorDocumentElement, (String)xPath, (NamespaceContext)null, (QName)XPathConstants.NODE);
                    originalDocuElement = (Element)docuNode;
                }
                catch (XPathExpressionException docuNode) {
                    // empty catch block
                }
            }
            if (originalDocuElement != null) {
                boolean indexExists;
                String originalDocuLocation = originalDocuElement.getAttribute("location");
                String originalDocuIndexDocument = originalDocuElement.getAttribute("indexDocument");
                boolean locationExists = originalDocuLocation != null && !originalDocuLocation.equals("");
                boolean bl = indexExists = originalDocuIndexDocument != null && !originalDocuIndexDocument.equals("");
                if (locationExists || indexExists) {
                    Element documentation = descriptorDocument.createElementNS("http://e2e.ch/bridge", "Documentation");
                    if (locationExists) {
                        documentation.setAttribute("location", originalDocuLocation);
                    }
                    if (indexExists) {
                        documentation.setAttribute("indexDocument", originalDocuIndexDocument);
                    }
                    documentElement.appendChild(documentation);
                }
            }
        }
        return descriptorDocument;
    }

    @Override
    public String toString() {
        return "deploymentDescriptor";
    }
}

