/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui;

import ch.e2e.builder.analyzer.gui.TransactionLogDiagramView;
import ch.e2e.builder.analyzer.gui.TransactionLogOverviewView;
import ch.e2e.builder.analyzer.gui.TransactionLogViewCard;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogTransaction;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;

public class TransactionLogView
extends MainPanelView {
    private static final String CARD_OVERVIEW = "overview";
    private static final String CARD_DIAGRAM = "sequenceDiagram";
    private E2EBuilderModule module;
    private TransactionLogOverviewView overview;
    private TransactionLogDiagramView sequenceDiagram;
    private TransactionLogObject root;

    public TransactionLogView(E2EBuilderModule module) {
        this.module = module;
        this.createGui();
    }

    public void refresh() {
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object newRoot) {
        if (this.root == null || !this.root.equals(newRoot)) {
            TransactionLogViewCard selectedCard;
            this.root = (TransactionLogObject)newRoot;
            if (this.root == null || this.root instanceof TransactionLogsRoot || this.root instanceof TransactionLog) {
                selectedCard = this.overview;
                this.show(CARD_OVERVIEW);
            } else {
                this.root = this.findTransaction(this.root);
                selectedCard = this.sequenceDiagram;
                this.show(CARD_DIAGRAM);
            }
            selectedCard.setRoot(this.root);
        }
    }

    private void show(String card) {
        ((CardLayout)this.getLayout()).show((Container)((Object)this), card);
    }

    public Object getPrintableObject() {
        return null;
    }

    private TransactionLogTransaction findTransaction(TransactionLogObject root) {
        TransactionLogTransaction transaction = null;
        if (root != null) {
            TransactionLogObject o = root;
            do {
                if (o instanceof TransactionLogTransaction) {
                    transaction = (TransactionLogTransaction)o;
                    continue;
                }
                o = o.getParent();
            } while (transaction == null && o != null);
        }
        return transaction;
    }

    private void createGui() {
        this.setLayout(new CardLayout());
        this.overview = new TransactionLogOverviewView(this.module);
        this.sequenceDiagram = new TransactionLogDiagramView(this.module);
        this.add(this.overview, CARD_OVERVIEW);
        this.add((Component)((Object)this.sequenceDiagram), CARD_DIAGRAM);
    }
}

