/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FixedSizeDocument
extends PlainDocument {
    private int rows;
    private int columns;
    private int lines = 0;
    private int charsInLine = 0;
    private int[] lineLengths;

    public FixedSizeDocument(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.lineLengths = new int[rows];
    }

    @Override
    public void insertString(int offset, String insert, AttributeSet attributes) throws BadLocationException {
        int actualLine = this.getActualLine(offset);
        if (insert.indexOf(10) != -1) {
            this.insertStringWithNewLine(offset, insert, attributes, actualLine);
        } else {
            this.insertStringWithoutNewLine(offset, insert, attributes, actualLine);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        String text = this.getText(offset, length);
        int actualLine = this.getActualLine(offset);
        if (text.indexOf(10) != -1) {
            int line = actualLine;
            int count = 0;
            for (int i = 0; i < length; ++i) {
                if (text.charAt(i) == '\n') {
                    ++line;
                    ++count;
                    continue;
                }
                int n = line;
                this.lineLengths[n] = this.lineLengths[n] - 1;
            }
            int n = actualLine;
            this.lineLengths[n] = this.lineLengths[n] + this.lineLengths[line];
            this.lineLengths[line] = 0;
            this.lines -= count;
            this.sortLines(actualLine, count);
        } else {
            int n = actualLine;
            this.lineLengths[n] = this.lineLengths[n] - length;
        }
        super.remove(offset, length);
        if (this.lineLengths[actualLine] > this.columns) {
            this.insertBreak(actualLine, this.lineLengths[actualLine]);
        }
    }

    private void insertStringWithNewLine(int offset, String insert, AttributeSet attributes, int actualLine) throws BadLocationException {
        int[] insertedLines = new int[this.rows];
        int addedLines = this.getInsertedLines(insert, insertedLines);
        if (this.lines + addedLines > this.rows - 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int i = 0;
        int newLines = this.lines + addedLines;
        int posInLine = this.getPositionInLine(offset, actualLine);
        int lastLineOffset = this.lineLengths[actualLine] - posInLine;
        insertedLines[0] = insertedLines[0] + posInLine;
        this.lineLengths[actualLine] = insertedLines[addedLines] + lastLineOffset;
        boolean textPos = false;
        for (i = 0; i < addedLines; ++i) {
            if (insertedLines[i] <= this.columns) continue;
            if (++newLines > this.rows - 1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            ++addedLines;
            int lineRest = insertedLines[i] - this.columns;
            insertedLines[i] = this.columns;
            for (int j = insertedLines.length - 1; j > i + 1; --j) {
                insertedLines[j] = insertedLines[j - 1];
            }
            insertedLines[i + 1] = lineRest;
            int index = 0;
            for (int k = 0; k < i; ++k) {
                index += insertedLines[i];
            }
            String dummy = insert;
            insert = dummy.substring(0, index += this.columns) + "\n" + dummy.substring(index, dummy.length());
        }
        this.shiftLines(this.lineLengths, addedLines);
        for (i = 0; i < addedLines; ++i) {
            this.lineLengths[actualLine + i] = insertedLines[i];
        }
        this.lines = newLines;
        super.insertString(offset, insert, attributes);
    }

    private void insertStringWithoutNewLine(int offset, String insert, AttributeSet attributes, int pActualLine) throws BadLocationException {
        int lineLength = this.lineLengths[pActualLine] + insert.length();
        if (lineLength > this.columns) {
            if (this.lines == this.rows - 1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, insert, attributes);
            this.insertBreak(pActualLine, lineLength);
            return;
        }
        int n = pActualLine;
        this.lineLengths[n] = this.lineLengths[n] + insert.length();
        super.insertString(offset, insert, attributes);
    }

    private int getInsertedLines(String insert, int[] insertedLines) {
        int newLineCount = 0;
        for (int i = 0; i < insert.length(); ++i) {
            if (insert.charAt(i) == '\n') {
                ++newLineCount;
                continue;
            }
            int n = newLineCount;
            insertedLines[n] = insertedLines[n] + 1;
        }
        return newLineCount;
    }

    private int getActualLine(int textPos) throws BadLocationException {
        String text = this.getText(0, textPos);
        int lineCount = 0;
        for (int i = 0; i < textPos; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lineCount;
        }
        return lineCount;
    }

    private void insertBreak(int actualLine, int lineLength) throws BadLocationException {
        int i;
        ++this.lines;
        int pos = 0;
        for (i = 0; i < actualLine; ++i) {
            pos += this.lineLengths[i] + 1;
        }
        this.lineLengths[actualLine] = this.columns;
        for (i = this.rows - 1; i > actualLine + 1; --i) {
            this.lineLengths[i] = this.lineLengths[i - 1];
        }
        this.lineLengths[actualLine + 1] = lineLength - this.columns;
        super.insertString(pos + this.columns, "\n", null);
    }

    private void sortLines(int actualLine, int removedLines) {
        int i;
        for (i = actualLine + 1; i < this.rows - removedLines; ++i) {
            this.lineLengths[i] = this.lineLengths[i + removedLines];
        }
        for (i = this.rows - 1; i > this.rows - 1 - removedLines; --i) {
            this.lineLengths[i] = 0;
        }
    }

    private int getPositionInLine(int textPos, int actualLine) {
        for (int i = 0; i < actualLine; ++i) {
            textPos -= this.lineLengths[i] + 1;
        }
        return textPos;
    }

    private void shiftLines(int[] lines, int shiftSize) {
        int length = lines.length;
        for (int i = 0; i < shiftSize; ++i) {
            lines[length - 1 - i] = lines[length - 1 - i - shiftSize];
            lines[length - 1 - i - shiftSize] = 0;
            if (length - 1 - i - shiftSize == 0) break;
        }
    }
}

