/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.request.Logging;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.traceviewer.ShowErrorEvent;
import ch.e2e.builder.traceviewer.ShowStatusEvent;
import ch.e2e.builder.traceviewer.execute.rest.AsyncRequest;
import ch.e2e.builder.traceviewer.execute.rest.AsyncRequestClient;
import ch.e2e.event.EventController;
import java.util.EventObject;

public abstract class RequestTransaction<R>
extends E2EBuilderTransaction {
    private static final AsyncRequestClient CLIENT = new AsyncRequestClient();
    private final E2EBuilderModule module;
    private final AsyncRequestClient client;

    public RequestTransaction(E2EBuilderModule traceViewer) {
        this(traceViewer, CLIENT);
    }

    RequestTransaction(E2EBuilderModule traceViewer, AsyncRequestClient client) {
        this.module = traceViewer;
        this.client = client;
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public String getDescription() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Object doTransaction(Object transactionData) throws Throwable {
        long start = System.currentTimeMillis();
        AsyncRequest request = (AsyncRequest)transactionData;
        request.setResponse(this.performRequest(request));
        String msg = String.format("Done. %d ms", System.currentTimeMillis() - start);
        Logging.logger.finer(msg);
        this.showStatus(msg);
        return request;
    }

    protected R performRequest(AsyncRequest<R> request) throws Exception {
        return (R)this.client.performRequest(request);
    }

    public void prepareTransaction() {
    }

    public boolean doErrorHandling(Throwable error) {
        Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "doErrorHandling", error);
        this.showError(error);
        this.showErrorDialog(error);
        return false;
    }

    protected void showErrorDialog(Throwable error) {
        if (error instanceof RequestException) {
            E2EBuilderInfoDialog.error((String)this.module.getTranslation(((RequestException)error).getTitle(), ((RequestException)error).getTitle()), (String)this.module.getTranslation(((RequestException)error).getSubtitle(), ((RequestException)error).getSubtitle()), (String)this.getErrorMessage(error));
        } else {
            E2EBuilderInfoDialog.error((String)this.getErrorMessage(error));
        }
    }

    protected String getErrorMessage(Throwable error) {
        return error instanceof NullPointerException ? error.getClass().getName() : error.getMessage();
    }

    protected void showError(Throwable error) {
        EventController.fire((EventObject)new ShowErrorEvent((Object)this, error.toString()));
    }

    protected void showStatus(String msg) {
        EventController.fire((EventObject)new ShowStatusEvent((Object)this, msg));
    }
}

