/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.module;

import ch.e2e.builder.base.application.ApplicationClosingVetoException;
import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.AddMenuItemEvent;
import ch.e2e.builder.base.application.abstracts.AddMenuSeparatorEvent;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.application.abstracts.ModuleReleasedEvent;
import ch.e2e.builder.base.application.abstracts.ModuleShownEvent;
import ch.e2e.builder.base.application.abstracts.RegisterMenuEventEvent;
import ch.e2e.builder.base.application.abstracts.SelectMenuItemEvent;
import ch.e2e.builder.base.application.abstracts.SetMenuEnabledEvent;
import ch.e2e.builder.base.application.abstracts.SetMenuItemEnabledEvent;
import ch.e2e.builder.base.application.abstracts.ShowStatusEvent;
import ch.e2e.builder.base.event.ApplicationClosingEvent;
import ch.e2e.builder.base.event.ApplicationWantsCloseEvent;
import ch.e2e.builder.base.event.ClearMessageViewEvent;
import ch.e2e.builder.base.event.RefreshEvent;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModuleDescriptionPanel;
import ch.e2e.builder.base.gui.NoModuleLicensePanel;
import ch.e2e.builder.base.gui.menu.PredefinedMenuItems;
import ch.e2e.builder.base.io.E2EBuilderFileView;
import ch.e2e.builder.base.message.E2EBuilderMessage;
import ch.e2e.builder.base.message.MessageTypesPool;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.base.module.Logging;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.plugin.module.ModulePlugin;
import ch.e2e.builder.base.plugin.project.PluginProjectManager;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.ProjectSetting;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.resource.Properties;
import ch.e2e.swing.event.MenuEventObject;
import ch.e2e.swing.filechooser.FileDescription;
import ch.e2e.swing.filechooser.FileIconPool;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class E2EBuilderModule
implements PredefinedMenuItems,
ProjectListener {
    private ModuleInfo moduleInfo;
    private Properties properties;
    private ProjectPool projectPool;
    private boolean refreshAllways = false;
    private boolean active = false;
    private ArrayList<ProjectListener> projectListener = new ArrayList();
    private ModulePlugin plugin;
    private ModuleDescriptionPanel noFoundMainPanel;
    private NoModuleLicensePanel notFoundOverviewPanel;
    private ProjectSettingObjectWSChecker projectSettingObjectWSChecker;

    public ProjectSettingObjectWSChecker getProjectSettingObjectWSChecker() {
        return this.projectSettingObjectWSChecker;
    }

    public void setProjectSettingObjectWSChecker(ProjectSettingObjectWSChecker projectSettingObjectWSChecker) {
        this.projectSettingObjectWSChecker = projectSettingObjectWSChecker;
    }

    protected E2EBuilderModule(ModuleInfo moduleInfo, Properties properties, String modulePackagePrefix) {
        this.moduleInfo = moduleInfo;
        this.properties = properties;
        E2EBuilderTranslator.addTranslations((String)moduleInfo.getName(), (String[])this.getTranslationProperties());
        this.addEventHandler();
        this.registerFileIcons();
        this.registerMessageTypes();
        System.setProperty(this.getClass().getName() + ".version", moduleInfo.getVersion());
        this.checkParentApplication(modulePackagePrefix);
    }

    private void checkParentApplication(String modulePackagePrefix) {
        String pluginClassName = this.getPluginClassName(modulePackagePrefix);
        if (pluginClassName != null) {
            this.createPlugin(pluginClassName);
        }
    }

    protected String getPluginClassName(String modulePackagePrefix) {
        if (!modulePackagePrefix.equals("")) {
            StringBuffer classname = new StringBuffer(this.getClass().getName());
            classname.insert("ch.e2e.builder".length(), modulePackagePrefix.toLowerCase());
            classname.append("Plugin");
            return classname.toString();
        }
        return null;
    }

    public final void guiInitialized() {
    }

    public boolean hasPlugin() {
        return this.plugin != null;
    }

    public ModulePlugin getPlugin() {
        return this.plugin;
    }

    private void createPlugin(String classname) {
        try {
            this.plugin = null;
            Class<?> pluginClass = Class.forName(classname);
            if (ModulePlugin.class.isAssignableFrom(pluginClass)) {
                Class<?> moduleClass = this.getClass();
                while (moduleClass != null && this.plugin == null) {
                    try {
                        Constructor<?> constructor = pluginClass.getConstructor(moduleClass);
                        this.plugin = (ModulePlugin)constructor.newInstance(this);
                        this.plugin.initialize();
                    }
                    catch (NoSuchMethodException e) {
                        if ((moduleClass = moduleClass.getSuperclass()) != null) continue;
                        throw e;
                    }
                }
            }
            String packageName = pluginClass.getPackage().getName();
            String pluginInfo = packageName.replace('.', '/') + "/.info";
            InputStream in = pluginClass.getClassLoader().getResourceAsStream(pluginInfo);
            if (in != null) {
                Properties pluginProperties = new Properties(in);
                this.moduleInfo.addPluginInfo(pluginProperties);
                System.setProperty(this.getClass().getName() + ".plugin.version", this.moduleInfo.getPluginVersion());
            }
        }
        catch (ClassNotFoundException e) {
            Logging.logger.fine("No special module plugin (" + classname + ") for module '" + this.moduleInfo.getName() + "' found");
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "", e);
        }
    }

    public void builderInitialized() {
    }

    public final void finalizeInitialization() {
        if (this.plugin != null) {
            this.plugin.guiInitialized();
        }
        this.builderInitialized();
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeChanging(ProjectEvent event) {
    }

    public void addProjectListener(ProjectListener projectListener) {
        if (this.projectPool == null) {
            this.projectListener.add(projectListener);
        } else {
            this.projectPool.addProjectListener(projectListener);
        }
    }

    public void removeProjectListener(ProjectListener projectListener) {
        if (this.projectPool == null) {
            this.projectListener.remove(projectListener);
        } else {
            this.projectPool.removeProjectListener(projectListener);
        }
    }

    public void doTransaction(E2EBuilderTransaction transaction, Object transactionData) {
        EventController.fire((EventObject)new DoTransactionEvent(this, transaction, transactionData));
    }

    public Icon getIcon() {
        return this.moduleInfo.getIcon();
    }

    public boolean applicationWantsClose() {
        return true;
    }

    protected void setRefreshAllways(boolean refreshAllways) {
        this.refreshAllways = refreshAllways;
    }

    public void applicationClosing() {
    }

    public ProjectSetting[] getProjectSettings() {
        return new ProjectSetting[0];
    }

    public final void setProjectPool(ProjectPool projectPool) {
        if (this.projectPool == null) {
            this.projectPool = projectPool;
            projectPool.addProjectListener(this);
            int length = this.projectListener.size();
            for (int i = 0; i < length; ++i) {
                projectPool.addProjectListener(this.projectListener.get(i));
            }
            this.projectListener.clear();
            this.projectListener = null;
        }
    }

    public ProjectPool getProjectPool() {
        return this.projectPool;
    }

    public boolean setProjectProperty(String key, boolean value) throws PropertyVetoException {
        return this.projectPool.getActualProject().set(this.getName(), key, value);
    }

    public boolean setProjectProperty(String key, int value) throws PropertyVetoException {
        return this.projectPool.getActualProject().set(this.getName(), key, value);
    }

    public boolean setProjectProperty(String key, double value) throws PropertyVetoException {
        return this.projectPool.getActualProject().set(this.getName(), key, value);
    }

    public boolean setProjectProperty(String key, Object value) throws PropertyVetoException {
        return this.projectPool.getActualProject().set(this.getName(), key, value);
    }

    public boolean getProjectProperty(String key, boolean defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public int getProjectProperty(String key, int defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public double getProjectProperty(String key, double defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public String getProjectProperty(String key, String defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public File getProjectProperty(String key, File defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public File getProjectProperty(String key, File defaultValue, boolean relative) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue, relative);
    }

    public Object getProjectProperty(String key, Object defaultValue) {
        return this.projectPool.getActualProject().get(this.getName(), key, defaultValue);
    }

    public boolean hasProjectProperty(String key) {
        return this.projectPool.getActualProject().hasProperty(this.getName(), key);
    }

    public void removeProjectProperty(String key) {
        this.projectPool.getActualProject().removeProperty(this.getName(), key);
    }

    public boolean setGenericProjectProperty(String key, boolean value) throws PropertyVetoException {
        return this.projectPool.getActualProject().setGenericValue(key, value);
    }

    public boolean setGenericProjectProperty(String key, int value) throws PropertyVetoException {
        return this.projectPool.getActualProject().setGenericValue(key, value);
    }

    public boolean setGenericProjectProperty(String key, double value) throws PropertyVetoException {
        return this.projectPool.getActualProject().setGenericValue(key, value);
    }

    public boolean setGenericProjectProperty(String key, Object value) throws PropertyVetoException {
        return this.projectPool.getActualProject().setGenericValue(key, value);
    }

    public boolean getGenericProjectProperty(String key, boolean defaultValue) {
        return this.projectPool.getActualProject().getGenericValue(key, defaultValue);
    }

    public int getGenericProjectProperty(String key, int defaultValue) {
        return this.projectPool.getActualProject().getGenericValue(key, defaultValue);
    }

    public double getGenericProjectProperty(String key, double defaultValue) {
        return this.projectPool.getActualProject().getGenericValue(key, defaultValue);
    }

    public String getGenericProjectProperty(String key, String defaultValue) {
        return this.projectPool.getActualProject().getGenericValue(key, defaultValue);
    }

    public Object getGenericProjectProperty(String key, Object defaultValue) {
        return this.projectPool.getActualProject().getGenericValue(key, defaultValue);
    }

    public boolean hasGenericProjectProperty(String key) {
        return this.projectPool.getActualProject().hasProperty(key);
    }

    public void removeGenericProjectProperty(String key) {
        this.projectPool.getActualProject().removeProperty(key);
    }

    public boolean isIgnoreCaughtErrors() {
        return this.getGenericProjectProperty("ignore.caught.errors", false);
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                E2EBuilderModule.this.applicationClosing();
            }
        }, ApplicationClosingEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws ApplicationClosingVetoException {
                if (!E2EBuilderModule.this.applicationWantsClose()) {
                    throw new ApplicationClosingVetoException(event);
                }
            }
        }, ApplicationWantsCloseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                if (E2EBuilderModule.this.active || E2EBuilderModule.this.refreshAllways) {
                    if (E2EBuilderModule.this.plugin == null) {
                        E2EBuilderModule.this.refresh();
                    } else {
                        E2EBuilderModule.this.plugin.refresh();
                    }
                }
            }
        }, RefreshEvent.class);
    }

    public String getDefaultMessageViewTitle() {
        return "Scheer PAS Builder Messages";
    }

    public final void clearMessageView() {
        this.clearMessageView(this.getDefaultMessageViewTitle());
    }

    public void clearMessageView(String messageView) {
        EventController.fire((EventObject)((Object)new ClearMessageViewEvent(this, this.moduleInfo.getName(), messageView)));
    }

    public final void showMessage(String message, String type, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, null, type, this.moduleInfo.getName(), messageView));
    }

    public final void showMessage(String message, Map<String, String> parameters, String type, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, parameters, type, this.moduleInfo.getName(), messageView));
    }

    public final void showMessage(E2EBuilderMessage message) {
        this.showMessage(message, this.getDefaultMessageViewTitle());
    }

    public final void showMessage(E2EBuilderMessage message, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, messageView));
    }

    public final void showInfo(String message) {
        this.showInfo(message, this.getDefaultMessageViewTitle());
    }

    public final void showInfo(String message, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, null, "info", this.moduleInfo.getName(), messageView));
    }

    public final void showInfo(String message, Map<String, String> parameters, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, parameters, "info", this.moduleInfo.getName(), messageView));
    }

    public final void showWarning(String message) {
        this.showWarning(message, this.getDefaultMessageViewTitle());
    }

    public final void showWarning(String message, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, null, "warning", this.moduleInfo.getName(), messageView));
    }

    public final void showWarning(String message, Map<String, String> parameters, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, parameters, "warning", this.moduleInfo.getName(), messageView));
    }

    public final void showError(String message) {
        this.showError(message, this.getDefaultMessageViewTitle());
    }

    public final void showError(String message, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, null, "error", this.moduleInfo.getName(), messageView));
    }

    public final void showError(String message, Map<String, String> parameters, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, parameters, "error", this.moduleInfo.getName(), messageView));
    }

    public final void showFatalError(String message, String messageView) {
        EventController.fire((EventObject)new SendMessageEvent((Object)this, message, null, "fatalerror", this.moduleInfo.getName(), messageView));
    }

    public abstract JComponent getMainWindow();

    public final JComponent getMainPanel() {
        JComponent mainPanel = this.getMainWindow();
        if (mainPanel == null) {
            if (this.noFoundMainPanel == null) {
                this.noFoundMainPanel = new ModuleDescriptionPanel(this);
            }
            mainPanel = this.noFoundMainPanel;
        }
        return mainPanel;
    }

    public abstract JComponent getOverviewWindow();

    public final JComponent getOverviewPanel() {
        JComponent overviewPanel = this.getOverviewWindow();
        if (overviewPanel == null) {
            if (this.notFoundOverviewPanel == null) {
                this.notFoundOverviewPanel = new NoModuleLicensePanel(this);
            }
            overviewPanel = this.notFoundOverviewPanel;
        }
        return overviewPanel;
    }

    public boolean isLicenseRequired() {
        return false;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getTranslation(String key) {
        return E2EBuilderTranslator.getModuleTranslation((String)this.moduleInfo.getName(), (String)key);
    }

    public String getTranslation(String key, String defaultTranslation) {
        return E2EBuilderTranslator.getModuleTranslation((String)this.moduleInfo.getName(), (String)key, (String)defaultTranslation);
    }

    public String[] getTranslationProperties() {
        return new String[]{this.getClass().getPackage().getName() + ".properties.translations"};
    }

    private void registerFileIcons() {
        this.registerFileIcon("e2ebuilder", E2EBuilderIcons.PROJECT_ICON);
        Properties properties = new Properties(this.getClass().getPackage().getName() + ".properties.fileicons", this.getClass().getClassLoader());
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.registerFileIcon(key, properties.getString(key));
        }
    }

    private void registerMessageTypes() {
        Properties properties = new Properties(this.getClass().getPackage().getName() + ".properties.messagetypes", this.getClass().getClassLoader());
        if (properties.exists()) {
            MessageTypesPool.registerMessageTypes((String)this.getName(), (Properties)properties);
        }
    }

    public final boolean show() {
        boolean result = this.prepare();
        if (result) {
            EventController.fire((EventObject)new ModuleShownEvent(this, this));
            this.active = true;
        }
        return result;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activated() {
    }

    public void removed() {
    }

    public final boolean remove() {
        boolean result = this.release();
        if (result) {
            EventController.fire((EventObject)new ModuleReleasedEvent(this, this));
            this.active = false;
        }
        return result;
    }

    protected boolean prepare() {
        return true;
    }

    protected boolean release() {
        return true;
    }

    public final String getName() {
        return this.moduleInfo.getName();
    }

    public final String getTitle() {
        return this.moduleInfo.getTitle();
    }

    public final String getShorttitle() {
        return this.moduleInfo.getShorttitle();
    }

    public void applicationWindowActivated() {
    }

    public void refresh() {
    }

    public void registerFileIcon(String extension, String imageFilename) {
        FileIconPool.getInstance().registerIcon(extension, imageFilename, this.getClass().getClassLoader());
    }

    public void registerFileIcon(String extension, Icon icon) {
        FileDescription fileExtension = new FileDescription();
        E2EBuilderFileView.getInstance().registerFileDescription(extension, fileExtension);
    }

    public void registerMenuEvent(String defaultItem, EventExecuter eventExecuter) {
        EventController.fire((EventObject)new RegisterMenuEventEvent(this, this, defaultItem, eventExecuter));
    }

    public final void addMenuItem(String[] itemNames, Icon icon, MenuEventObject event, int index, EventExecuter executer) {
        this.addMenuItem(itemNames, icon, event, index);
        if (itemNames.length > 1 && event != null) {
            this.registerMenuEvent(itemNames[itemNames.length - 1], executer);
        }
    }

    public final void addMenuItem(String[] itemNames, Icon icon, MenuEventObject event, int index) {
        EventController.fire((EventObject)new AddMenuItemEvent(this, this, itemNames, icon, event, index));
    }

    public final void addMenuSeparator(String[] menuNames) {
        EventController.fire((EventObject)new AddMenuSeparatorEvent(this, this, menuNames));
    }

    public final ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public final void setFileSaveAllEnabled(boolean enabled) {
    }

    public final void setFileSaveAsEnabled(boolean enabled) {
    }

    public final void setFileSaveEnabled(boolean enabled) {
        this.setModified(enabled);
    }

    public final void setMenuEnabled(String menu, boolean enabled) {
        EventController.fire((EventObject)new SetMenuEnabledEvent(this, this, menu, enabled));
    }

    public final void setMenuItemEnabled(String[] itemNames, boolean enabled) {
        EventController.fire((EventObject)new SetMenuItemEnabledEvent(this, this, itemNames, enabled));
    }

    public final void setMenuItemSelected(String[] itemNames, boolean selected) {
        EventController.fire((EventObject)new SelectMenuItemEvent(this, this, itemNames, selected));
    }

    public void setModified(boolean modified) {
        if (modified) {
            EventController.fire((EventObject)new ShowStatusEvent(this, this, E2EBuilderTranslator.getTranslation((String)"modified", (String)"modified"), "status_messages"));
        } else {
            EventController.fire((EventObject)new ShowStatusEvent(this, this, "", "status_messages"));
        }
    }

    public void showStatusMessage(String message) {
        EventController.fire((EventObject)new ShowStatusEvent(this, this, message, "status_messages"));
    }

    public final void setFileCloseEnabled(boolean enabled) {
    }

    public final void setFileOpenEnabled(boolean enabled) {
    }

    public final void setPrintEnabled(boolean enabled) {
        EventController.fire((EventObject)new SetMenuItemEnabledEvent(this, this, new String[]{"menu.project", "menu.project.print"}, enabled));
    }

    final void setModuleInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public Object getPrintableObject() {
        return null;
    }

    public JMenuItem createMenuItem(String key) {
        return ComponentFactory.createMenuItem(key, this);
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(String key) {
        return ComponentFactory.createCheckBoxMenuItem(key, this);
    }

    public JLabel createLabel(String key) {
        return ComponentFactory.createLabel(key, this);
    }

    public JButton createButton(String key) {
        return ComponentFactory.createButton(key, this);
    }

    public JCheckBox createCheckBox(String key) {
        return ComponentFactory.createCheckBox(key, this);
    }

    public JRadioButton createRadioButton(String key) {
        return ComponentFactory.createRadioButton(key, this);
    }

    public TitledBorder createTitledBorder(String key) {
        return ComponentFactory.createTitledBorder(key, this);
    }

    public TitledBorder createTitledBorder(String key, Border border) {
        return ComponentFactory.createTitledBorder(key, border, this);
    }

    public PluginProjectManager getPluginProjectManager() {
        return PluginProjectManager.getInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createModuleObject(Class objectClass) {
        Object result = null;
        try {
            Class<?> moduleClass = this.getClass();
            while (moduleClass != null && result == null) {
                try {
                    Constructor constructor = objectClass.getConstructor(moduleClass);
                    result = constructor.newInstance(this);
                }
                catch (NoSuchMethodException e) {
                    if ((moduleClass = moduleClass.getSuperclass()) != null) continue;
                    throw e;
                    return result;
                }
            }
        }
        catch (Exception ex) {
            Logging.logger.throwing(E2EBuilderModule.class.getName(), "createObject", ex);
        }
        return result;
    }
}

