/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.event.ClearMessageViewEvent;
import ch.e2e.builder.base.event.MessageViewChangedEvent;
import ch.e2e.builder.base.event.MessageViewChangedListener;
import ch.e2e.builder.base.event.MessageViewChangedMulticaster;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.Logging;
import ch.e2e.builder.base.gui.MessagesParentWindow;
import ch.e2e.builder.base.message.E2EBuilderMessage;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.Message;
import ch.e2e.swing.MessageTextPane;
import ch.e2e.swing.event.MessageActionEvent;
import ch.e2e.swing.event.MessageActionListener;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MessagePane
extends JPanel
implements EventExecuter,
MouseListener,
Logging {
    private MessageViewChangedListener listener;
    private HashMap<String, HashMap<String, MessageTextPane>> views = new HashMap();
    private HashMap<String, JideTabbedPane> tabbedPanes = new HashMap();
    private String activeModule;
    private MessageAction messageAction;
    private ArrayList<String> registeredModules = new ArrayList();
    private MessagesParentWindow parent;

    public MessagePane(MessagesParentWindow parent) {
        super(new BorderLayout());
        this.parent = parent;
        this.messageAction = new MessageAction();
        this.addEventHandler();
    }

    public void registerModule(String module) {
        this.registeredModules.add(module);
    }

    public boolean isModuleRegistered(String module) {
        return this.registeredModules.contains(module);
    }

    public void execute(EventObject event) {
        this.addMessage((SendMessageEvent)event);
    }

    public void addMessageViewChangedListener(MessageViewChangedListener listener) {
        this.listener = MessageViewChangedMulticaster.addListener(this.listener, listener);
    }

    public void removeMessageViewChangedListener(MessageViewChangedListener listener) {
        this.listener = MessageViewChangedMulticaster.removeListener(this.listener, listener);
    }

    public void setActiveModule(String activeModule) {
        this.activeModule = activeModule;
        JideTabbedPane modulePane = this.tabbedPanes.get(activeModule);
        if (modulePane != null) {
            this.addModulePane(modulePane);
        }
    }

    private void addModulePane(JideTabbedPane modulePane) {
        this.removeAll();
        this.add((Component)modulePane, "Center");
    }

    public boolean isEmpty() {
        boolean empty = true;
        HashMap<String, MessageTextPane> moduleViews = this.views.get(this.activeModule);
        if (moduleViews != null) {
            Iterator<MessageTextPane> messageViews = moduleViews.values().iterator();
            while (messageViews.hasNext() && empty) {
                empty = messageViews.next().isEmpty();
            }
        }
        return empty;
    }

    private void fireMessageViewChanged() {
        if (this.listener != null) {
            this.listener.messageViewChanged(new MessageViewChangedEvent(this));
        }
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)this, SendMessageEvent.class);
        EventExecuter errorHandler = new EventExecuter(){

            public void execute(EventObject event) {
                MessagePane.this.addMessage((SendMessageEvent)((SendErrorEvent)event));
            }
        };
        EventController.register((EventExecuter)errorHandler, SendWarningEvent.class);
        EventController.register((EventExecuter)errorHandler, SendErrorEvent.class);
        EventController.register((EventExecuter)errorHandler, SendFatalErrorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MessagePane.this.clear((ClearMessageViewEvent)((Object)event));
            }
        }, ClearMessageViewEvent.class);
    }

    private void clear(ClearMessageViewEvent event) {
        HashMap<String, MessageTextPane> moduleViews;
        String moduleName = event.getModuleName();
        if (moduleName == null) {
            moduleName = this.activeModule;
        }
        if ((moduleViews = this.views.get(moduleName)) == null) {
            Iterator<String> panes = this.tabbedPanes.keySet().iterator();
            while (panes.hasNext() && moduleViews == null) {
                String name = panes.next();
                if (!this.tabbedPanes.get(name).isVisible()) continue;
                moduleViews = this.views.get(name);
                moduleName = name;
            }
        }
        if (moduleViews != null) {
            MessageTextPane view;
            JideTabbedPane modulePane;
            String viewName = event.getMessageView();
            if (viewName == null) {
                modulePane = this.getModulePane(moduleName);
                viewName = modulePane.getTitleAt(modulePane.getSelectedIndex());
            }
            if ((view = moduleViews.get(viewName)) != null) {
                view.clear();
                SwingUtilities.updateComponentTreeUI((Component)view);
                modulePane = this.tabbedPanes.get(moduleName);
                int index = modulePane.indexOfTab(viewName);
                modulePane.setSelectedIndex(index);
            }
        }
    }

    private void addMessage(SendMessageEvent event) {
        String module = event.getMessage().getModule();
        if (module != null && this.registeredModules.contains(module)) {
            this.parent.setVisibility(true);
            this.addMessage(event.getMessage(), event.getMessageView());
        }
    }

    private void addMessage(E2EBuilderMessage message, String messageView) {
        String moduleName = message.getModule();
        JideTabbedPane modulePane = this.getModulePane(moduleName);
        int selectedIndex = modulePane.getSelectedIndex();
        MessageTextPane view = null;
        String viewName = E2EBuilderTranslator.getModuleTranslation((String)moduleName, (String)messageView, (String)messageView);
        HashMap<String, Object> moduleViews = this.views.get(moduleName);
        if (moduleViews == null) {
            moduleViews = new HashMap();
            this.views.put(moduleName, moduleViews);
        } else {
            view = moduleViews.get(viewName);
        }
        if (view == null) {
            view = this.addModuleView(viewName, moduleViews, modulePane);
        }
        view.appendMessage((Message)message);
        int index = modulePane.indexOfTab(viewName);
        if (selectedIndex != index) {
            modulePane.setSelectedIndex(index);
            if (moduleName.equals(this.activeModule)) {
                this.fireMessageViewChanged();
            }
        }
    }

    private MessageTextPane addModuleView(String viewName, HashMap<String, MessageTextPane> moduleViews, JideTabbedPane modulePane) {
        final MessageTextPane messageView = new MessageTextPane(viewName, (MouseListener)this);
        messageView.addMessageActionListener((MessageActionListener)this.messageAction);
        moduleViews.put(viewName, messageView);
        JPanel view = new JPanel(new BorderLayout());
        view.add((Component)messageView, "Center");
        JPanel toolbar = new JPanel(new FlowLayout(0, 0, 1));
        JButton clearButton = ComponentFactory.createButton("popup.messageview.clear");
        toolbar.add(clearButton);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                messageView.clear();
                SwingUtilities.updateComponentTreeUI((Component)messageView);
            }
        });
        view.add((Component)toolbar, "North");
        modulePane.addTab(viewName, (Component)view);
        modulePane.doLayout();
        return messageView;
    }

    private JideTabbedPane getModulePane(String moduleName) {
        JideTabbedPane modulePane = this.tabbedPanes.get(moduleName);
        if (modulePane == null) {
            modulePane = new JideTabbedPane(3);
            this.tabbedPanes.put(moduleName, modulePane);
        }
        this.addModulePane(modulePane);
        return modulePane;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private class MessageAction
    implements MessageActionListener {
        private MessageAction() {
        }

        public void doMessageAction(MessageActionEvent event) {
            EventController.fire((EventObject)event);
        }
    }
}

