/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks;

import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsltCompilerTask
extends Task {
    private File srcdir;
    private File tempdir;
    private String src;
    private String srcSuffix = "xsl";
    private String binSuffix = "bin";
    private File output;
    private ArrayList<File> includedFiles = new ArrayList();
    private HashMap<String, String> nameSpaces = new HashMap();
    private ArrayList<String> elementPrefixes = new ArrayList();
    private HashMap<String, File> templates = new HashMap();

    public void execute() throws BuildException {
        this.checkParameter();
        File srcfile = new File(this.srcdir, this.src + '.' + this.srcSuffix);
        String filename = srcfile.getName();
        File startDir = srcfile.getParentFile();
        File scriptFile = new File(startDir, filename);
        Document xsltDoc = this.loadScriptFile(scriptFile);
        Document newDoc = (Document)xsltDoc.cloneNode(true);
        this.removeAllChilds(newDoc.getDocumentElement());
        ArrayList<String> scripts = new ArrayList<String>();
        this.readNamespacesAndExtension(xsltDoc);
        this.checkPackageEntry(xsltDoc, srcfile);
        this.importAllIncludes(xsltDoc, newDoc, true, scripts, srcfile);
        this.checkScripts(newDoc, scripts);
        this.saveDocument(newDoc);
    }

    private void checkScripts(Document newDoc, ArrayList scripts) {
        Element root = newDoc.getDocumentElement();
        int length = scripts.size();
        for (int i = 0; i < length; ++i) {
            String script = (String)scripts.get(i);
            if (!this.elementPrefixes.contains(script)) {
                this.elementPrefixes.add(script);
            }
            if (this.nameSpaces.containsKey(script)) continue;
            throw new BuildException("No namespace found for xsl:script '" + script + "'.");
        }
        this.setElementPrefixes(root);
        this.setNamespaces(root);
    }

    private void setNamespaces(Element root) {
        for (String prefix : this.nameSpaces.keySet()) {
            root.setAttribute("xmlns:" + prefix, this.nameSpaces.get(prefix));
        }
    }

    private void setElementPrefixes(Element root) {
        StringBuffer elementPrefixAttr = new StringBuffer();
        int length = this.elementPrefixes.size();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String prefix = this.elementPrefixes.get(i);
                elementPrefixAttr.append(prefix).append(' ');
            }
            root.setAttribute("extension-element-prefixes", elementPrefixAttr.substring(0, elementPrefixAttr.length() - 1));
        }
    }

    private void checkParameter() throws BuildException {
        if (this.srcdir == null) {
            throw new BuildException("The attribute 'srcdir' must be set.");
        }
        if (this.src == null) {
            throw new BuildException("The attribute 'src' must be set.");
        }
        if (this.output == null) {
            throw new BuildException("The attribute 'output' must be set.");
        }
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setTempdir(File tempdir) {
        this.tempdir = tempdir;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setSrcSuffix(String srcSuffix) {
        this.srcSuffix = srcSuffix;
    }

    public void setBinSuffix(String binSuffix) {
        this.binSuffix = binSuffix;
    }

    private Document loadScriptFile(File scriptFile) throws BuildException {
        try {
            return DomUtilities.parse((File)scriptFile, (boolean)false, (boolean)false);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void readNamespacesAndExtension(Document xsltDoc) {
        NamedNodeMap attributes = xsltDoc.getDocumentElement().getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            if (name.startsWith("xmlns:")) {
                this.addNamespaces(name, attribute);
                continue;
            }
            if (!name.equals("extension-element-prefixes")) continue;
            this.addElementPrefixes(attribute);
        }
    }

    private void addNamespaces(String name, Attr attribute) {
        String namespaceName = name.substring(6);
        if (!this.nameSpaces.containsKey(namespaceName)) {
            this.nameSpaces.put(namespaceName, attribute.getValue());
        }
    }

    private void addElementPrefixes(Attr attribute) {
        String value = attribute.getValue();
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        while (tokenizer.hasMoreTokens()) {
            String prefix = tokenizer.nextToken();
            if (this.elementPrefixes.contains(prefix)) continue;
            this.elementPrefixes.add(prefix);
        }
    }

    private void importAllIncludes(Document xsltDoc, Document newDoc, boolean rootDoc, ArrayList<String> scripts, File srcfile) {
        Element stylesheet = xsltDoc.getDocumentElement();
        NodeList childs = stylesheet.getChildNodes();
        int length = childs.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() == 3) continue;
            this.addNode(child, newDoc, scripts, srcfile, rootDoc);
        }
    }

    private void addNode(Node child, Document newDoc, ArrayList<String> scripts, File srcfile, boolean rootDoc) {
        String localName = child.getLocalName();
        if (localName != null) {
            if (localName.equals("include")) {
                this.addIncludesFile(child, srcfile.getParentFile(), newDoc, scripts, srcfile);
            } else if (localName.equals("script")) {
                this.addScriptDefinition(child, scripts, newDoc);
            } else if (localName.equals("template")) {
                this.addTemplate((Element)child, srcfile, newDoc);
            } else {
                this.addChild(child, rootDoc, localName, newDoc);
            }
        }
    }

    private void addChild(Node child, boolean rootDoc, String localName, Document newDoc) {
        if (child.getNodeType() != 8 && (rootDoc && localName.equals("output") || !localName.equals("output"))) {
            child = newDoc.importNode(child, true);
            newDoc.getDocumentElement().appendChild(child);
        }
    }

    private void addScriptDefinition(Node child, ArrayList<String> scripts, Document newDoc) {
        String prefix = ((Element)child).getAttribute("implements-prefix");
        if (!scripts.contains(prefix)) {
            scripts.add(prefix);
            child = newDoc.importNode(child, true);
            newDoc.getDocumentElement().appendChild(child);
        }
    }

    private void addTemplate(Element template, File srcfile, Document newDoc) {
        if (template.hasAttribute("name")) {
            String name = template.getAttribute("name");
            if (this.templates.containsKey(name)) {
                File file = this.templates.get(name);
                throw new BuildException("template '" + name + "' defined in " + srcfile.getAbsolutePath() + " is allready defined in " + file.getAbsolutePath());
            }
            this.templates.put(name, srcfile);
            template = (Element)newDoc.importNode(template, true);
            newDoc.getDocumentElement().appendChild(template);
        } else {
            template = (Element)newDoc.importNode(template, true);
            newDoc.getDocumentElement().appendChild(template);
        }
    }

    private void addIncludesFile(Node child, File startDir, Document newDoc, ArrayList<String> scripts, File srcfile) {
        String filename = ((Element)child).getAttribute("href");
        File scriptFile = new File(startDir, filename);
        if (!this.includedFiles.contains(scriptFile)) {
            this.includedFiles.add(scriptFile);
            if (scriptFile.exists()) {
                Document includedDoc = this.loadScriptFile(scriptFile);
                this.checkPackageEntry(includedDoc, scriptFile);
                this.readNamespacesAndExtension(includedDoc);
                this.importAllIncludes(includedDoc, newDoc, false, scripts, scriptFile);
            } else {
                String message = "Includes file '" + FileUtilities.getAbsolutePath((File)scriptFile) + "' of script '" + FileUtilities.getAbsolutePath((File)srcfile) + "' not found.";
                this.log("ERROR: " + message);
                throw new BuildException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(Document xsltDoc) {
        File outputFile;
        if (this.tempdir != null) {
            this.writeTempFiles(xsltDoc);
        }
        if (!(outputFile = new File(this.output, this.src + '.' + this.binSuffix)).getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        OutputStream outputStream = null;
        try {
            ZipOutputStream fileStream = new ZipOutputStream(new FileOutputStream(outputFile));
            fileStream.putNextEntry(new ZipEntry(outputFile.getName()));
            DomUtilities.serialize((OutputStream)fileStream, (Document)xsltDoc, (boolean)false);
        }
        catch (Throwable ex) {
            System.out.println(ex);
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (Exception fileStream) {}
            try {
                ((FileOutputStream)outputStream).close();
            }
            catch (Exception fileStream) {}
        }
    }

    private void writeTempFiles(Document xsltDoc) {
        try {
            File file = new File(this.tempdir, this.src + ".xsl");
            file = new File(this.tempdir, file.getName());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            DomUtilities.serialize((File)file, (Document)xsltDoc, (boolean)true);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private void removeAllChilds(Element element) {
        NodeList childs = element.getChildNodes();
        int length = childs.getLength();
        for (int i = 0; i < length; ++i) {
            element.removeChild(childs.item(0));
        }
    }

    private void checkPackageEntry(Document xsltDoc, File srcfile) {
        String packageName = this.getPackageName(xsltDoc);
        if (packageName.length() == 0) {
            this.log("WARNING: package entry is not defined in " + srcfile.getAbsoluteFile().getAbsolutePath());
        } else {
            String dirPath = FileUtilities.getAbsolutePath((File)srcfile.getParentFile());
            if (!(dirPath = dirPath.replace(File.separatorChar, '.')).endsWith(packageName)) {
                this.log("WARNING: package entry and directory don't match in file '" + FileUtilities.getAbsolutePath((File)srcfile) + "'.");
            }
        }
    }

    private String getPackageName(Document xsltDoc) {
        String packageName = null;
        NodeList children = xsltDoc.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length && packageName == null; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 8) continue;
            packageName = this.getPackage(node.getNodeValue());
        }
        return packageName == null ? "" : packageName;
    }

    private String getPackage(String comment) {
        String packageName = null;
        String[] lines = comment.split("\n");
        for (int i = 0; i < lines.length && packageName == null; ++i) {
            int index = lines[i].indexOf("package");
            if (index == -1) continue;
            packageName = lines[i].substring(index + 7).trim();
        }
        return packageName;
    }
}

