/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.xdk;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLSchemaReference;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.platform.xml.xdk.XDKNamespaceResolver;
import org.eclipse.persistence.platform.xml.xdk.XDKParser;
import org.eclipse.persistence.platform.xml.xdk.XDKTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XDKPlatform
implements XMLPlatform {
    private Method buildSchemaMethod;

    public XDKPlatform() {
        try {
            Class[] argTypes = new Class[]{URL.class};
            this.buildSchemaMethod = Helper.getDeclaredMethod(XSDBuilder.class, "build", argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public Node selectSingleNodeAdvanced(Node contextNode, String xPath, XMLNamespaceResolver xmlNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xmlNode = (XMLNode)contextNode;
            XDKNamespaceResolver xdkNamespaceResolver = new XDKNamespaceResolver(xmlNamespaceResolver);
            return xmlNode.selectSingleNode(xPath, (NSResolver)xdkNamespaceResolver);
        }
        catch (XSLException e) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)e));
        }
    }

    @Override
    public NodeList selectNodesAdvanced(Node contextNode, String xPath, XMLNamespaceResolver xmlNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xmlNode = (XMLNode)contextNode;
            XDKNamespaceResolver xdkNamespaceResolver = new XDKNamespaceResolver(xmlNamespaceResolver);
            return xmlNode.selectNodes(xPath, (NSResolver)xdkNamespaceResolver);
        }
        catch (XSLException e) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)e));
        }
    }

    @Override
    public Document createDocument() throws XMLPlatformException {
        return new XMLDocument();
    }

    @Override
    public Document createDocumentWithPublicIdentifier(String name, String publicIdentifier, String systemIdentifier) throws XMLPlatformException {
        try {
            XMLDocument xmlDocument = (XMLDocument)this.createDocument();
            Element rootElement = xmlDocument.createElement(name);
            xmlDocument.appendChild((Node)rootElement);
            xmlDocument.setDoctype(name, systemIdentifier, publicIdentifier);
            return xmlDocument;
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(e);
        }
    }

    @Override
    public Document createDocumentWithSystemIdentifier(String name, String systemIdentifier) throws XMLPlatformException {
        try {
            if (systemIdentifier == null) {
                Document document = this.createDocument();
                Element rootElement = document.createElement(name);
                document.appendChild(rootElement);
                return document;
            }
            XMLDocument xmlDocument = (XMLDocument)this.createDocument();
            Element rootElement = xmlDocument.createElement(name);
            xmlDocument.appendChild((Node)rootElement);
            xmlDocument.setDoctype(name, systemIdentifier, null);
            return xmlDocument;
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(e);
        }
    }

    @Override
    public boolean isWhitespaceNode(Text text) {
        String value;
        block3: {
            try {
                value = text.getNodeValue();
                if (value != null) break block3;
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return value.trim().equals("");
    }

    @Override
    public String resolveNamespacePrefix(Node contextNode, String namespacePrefix) throws XMLPlatformException {
        Node parentNode;
        if (namespacePrefix == null ? contextNode.getPrefix() == null : namespacePrefix.equals(contextNode.getPrefix())) {
            return contextNode.getNamespaceURI();
        }
        if (contextNode.getNodeType() == 1) {
            Element contextElement = (Element)contextNode;
            Attr namespaceDeclaration = null;
            namespaceDeclaration = namespacePrefix != null ? contextElement.getAttributeNode("xmlns:" + namespacePrefix) : contextElement.getAttributeNode("xmlns");
            if (namespaceDeclaration != null) {
                return namespaceDeclaration.getValue();
            }
        }
        if ((parentNode = contextNode.getParentNode()) != null && parentNode.getNodeType() == 1) {
            return this.resolveNamespacePrefix(parentNode, namespacePrefix);
        }
        return null;
    }

    @Override
    public XMLParser newXMLParser() {
        return new XDKParser();
    }

    @Override
    public XMLParser newXMLParser(Map<String, Boolean> parserFeatures) {
        return new XDKParser();
    }

    @Override
    public XMLTransformer newXMLTransformer() {
        return new XDKTransformer();
    }

    @Override
    public boolean validateDocument(Document document, URL xmlSchemaURL, ErrorHandler errorHandler) throws XMLPlatformException {
        XMLSchema xmlSchema = null;
        XSDValidator validator = null;
        try {
            Object[] args = new Object[]{xmlSchemaURL};
            xmlSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), args);
            validator = new XSDValidator();
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(xmlSchemaURL, e);
        }
        validator.setXMLProperty("fixedSchema", (Object)xmlSchema);
        XMLError xmlErr = new XMLError();
        try {
            validator.setError(xmlErr);
        }
        catch (SAXException saxex) {
            throw XMLPlatformException.xmlPlatformValidationException(saxex);
        }
        try {
            ((XMLDocument)document).validateContent(validator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors(xmlErr, errorHandler);
        return true;
    }

    @Override
    public boolean validate(Element elem, XMLDescriptor xmlDescriptor, ErrorHandler errorHandler) throws XMLPlatformException {
        XMLSchema xmlSchema;
        org.eclipse.persistence.oxm.schema.XMLSchemaReference schemaReference = xmlDescriptor.getSchemaReference();
        NamespaceResolver nsResolver = xmlDescriptor.getNamespaceResolver();
        XSDValidator validator = null;
        try {
            Object[] args = new Object[]{schemaReference.getURL()};
            xmlSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), args);
            validator = new XSDValidator();
        }
        catch (Exception ex) {
            throw XMLPlatformException.xmlPlatformValidationException(ex);
        }
        validator.setXMLProperty("fixedSchema", (Object)xmlSchema);
        XSDNode xsdNode = this.getNodeFromSchemaReference(xmlSchema, schemaReference, nsResolver);
        if (xsdNode == null) {
            validator.setXMLProperty("ORACLE_XSD_Root_Node", null);
        }
        if (schemaReference.getType() == 3) {
            if (xmlDescriptor.getDefaultRootElement() != null) {
                validator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)xsdNode);
            } else {
                validator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)((XSDElement)xsdNode).getType());
            }
        } else {
            validator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)xsdNode);
        }
        XMLError xmlErr = new XMLError();
        try {
            validator.setError(xmlErr);
        }
        catch (SAXException saxex) {
            throw XMLPlatformException.xmlPlatformValidationException(saxex);
        }
        try {
            ((XMLElement)elem).validateContent(validator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors(xmlErr, errorHandler);
        return true;
    }

    private void handleErrors(XMLError xmlErr, ErrorHandler errorHandler) {
        try {
            int numberOfMessages = xmlErr.getNumMessages();
            int x = 0;
            while (x < numberOfMessages) {
                SAXParseException saxParseException = new SAXParseException(xmlErr.getMessage(x), xmlErr.getPublicId(x), xmlErr.getSystemId(x), xmlErr.getLineNumber(x), xmlErr.getColumnNumber(x), xmlErr.getException(x));
                if (errorHandler == null) {
                    throw saxParseException;
                }
                errorHandler.fatalError(saxParseException);
                ++x;
            }
        }
        catch (SAXException xmlex) {
            throw XMLPlatformException.xmlPlatformValidationException(xmlex);
        }
    }

    private XSDNode getNodeFromSchemaReference(XMLSchema xmlSchema, XMLSchemaReference schemaRef, NamespaceResolver nsResolver) {
        if (schemaRef == null) {
            return null;
        }
        StringTokenizer nodes = new StringTokenizer(schemaRef.getSchemaContext(), "/");
        if (!nodes.hasMoreTokens()) {
            return null;
        }
        String namespace = "";
        String nodeName = nodes.nextToken();
        StringTokenizer prefixes = new StringTokenizer(nodeName, ":");
        if (prefixes.countTokens() > 1 && (namespace = nsResolver.resolveNamespacePrefix(prefixes.nextToken())) == null) {
            namespace = "";
        }
        nodeName = prefixes.nextToken();
        if (schemaRef.getType() == 2) {
            return xmlSchema.getType(namespace, nodeName, 2);
        }
        if (schemaRef.getType() == 1) {
            return xmlSchema.getType(namespace, nodeName, 1);
        }
        XSDElement node = xmlSchema.getElement(namespace, nodeName);
        while (nodes.hasMoreTokens()) {
            if ((node = this.findChildNode(node, nodes.nextToken())) != null) continue;
            return null;
        }
        return node;
    }

    protected XSDNode findChildNode(XSDElement parent, String childName) {
        XSDNode node = null;
        boolean successful = false;
        XSDNode[] children = ((XSDComplexType)parent.getType()).getElementSet();
        int i = 0;
        while (i < children.length) {
            node = children[i];
            if (node.getName().equals(childName)) {
                successful = true;
                break;
            }
            ++i;
        }
        if (successful) {
            return node;
        }
        return null;
    }

    @Override
    public void namespaceQualifyFragment(Element next) {
        this.namespaceQualifyFragment(next, new ArrayList<String>());
    }

    private void namespaceQualifyFragment(Element next, List<String> declaredPrefixes) {
        Attr namespaceDeclaration;
        String elementUri = next.getNamespaceURI();
        String elementPrefix = next.getPrefix();
        if (elementPrefix != null && (namespaceDeclaration = next.getAttributeNode("xmlns:" + elementPrefix)) == null && !declaredPrefixes.contains(elementPrefix)) {
            next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + elementPrefix, elementUri);
            declaredPrefixes.add(elementPrefix);
        }
        NamedNodeMap attributes = next.getAttributes();
        int attributesSize = attributes.getLength();
        int i = 0;
        while (i < attributesSize) {
            Attr nextAttribute = (Attr)attributes.item(i);
            String attributePrefix = nextAttribute.getPrefix();
            if (attributePrefix != null) {
                if ("http://www.w3.org/2000/xmlns/".equals(nextAttribute.getNamespaceURI())) {
                    declaredPrefixes.add(nextAttribute.getLocalName());
                } else {
                    String prefix;
                    String value;
                    int colonIndex;
                    Attr namespaceDeclaration2 = next.getAttributeNode("xmlns:" + attributePrefix);
                    if (namespaceDeclaration2 == null && !declaredPrefixes.contains(attributePrefix)) {
                        String attributeUri = nextAttribute.getNamespaceURI();
                        next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attributePrefix, attributeUri);
                        declaredPrefixes.add(attributePrefix);
                    }
                    if ("http://www.w3.org/2001/XMLSchema-instance".equals(nextAttribute.getNamespaceURI()) && "type".equals(nextAttribute.getLocalName()) && (colonIndex = (value = nextAttribute.getValue()).indexOf(58)) > -1 && (namespaceDeclaration2 = next.getAttributeNode("xmlns:" + (prefix = value.substring(0, colonIndex)))) == null && !declaredPrefixes.contains(prefix)) {
                        String uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(next, prefix);
                        next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                        declaredPrefixes.add(prefix);
                    }
                }
            }
            ++i;
        }
        NodeList children = next.getChildNodes();
        int numberOfNodes = children.getLength();
        int i2 = 0;
        while (i2 < numberOfNodes) {
            Node nextNode = children.item(i2);
            if (nextNode.getNodeType() == 1) {
                Element child = (Element)nextNode;
                this.namespaceQualifyFragment(child, declaredPrefixes);
            }
            ++i2;
        }
    }

    @Override
    public void setDisableSecureProcessing(boolean disableSecureProcessing) {
    }

    @Override
    public boolean isSecureProcessingDisabled() {
        return false;
    }
}

