/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.response.PersistentStateTraceContainer;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.traceviewer.testcase.Identifier;
import ch.e2e.builder.traceviewer.testcase.PersistentStateTestcaseFolder;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PersistentStateTestcase
extends AbstractAsynchronousTestcase {
    private final List<AbstractAsynchronousTestcase.Key> primaryKeys = new ArrayList<AbstractAsynchronousTestcase.Key>();

    public PersistentStateTestcase(File home, Identifier identifier) {
        super(home, identifier, 40);
    }

    public PersistentStateTestcase(File home) throws FileNotFoundException {
        super(home, 40);
    }

    public List<AbstractAsynchronousTestcase.Key> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(PersistentStateTestcaseFolder parent) {
        assert (parent != null);
        List<String> keyNames = parent.getPrimaryKeyNames();
        List<String> keyValues = this.getIdentifier().getPrimaryKeyValues();
        if (keyValues != null) {
            int size = Math.min(keyNames.size(), keyValues.size());
            for (int i = 0; i < size; ++i) {
                this.getPrimaryKeys().add(new AbstractAsynchronousTestcase.Key(keyNames.get(i), keyValues.get(i)));
            }
        }
    }

    public Object getChild(int index) {
        int i = index - this.getPrimaryKeys().size();
        return i < 0 ? this.getPrimaryKeys().get(index) : super.getChild(i);
    }

    public int getChildCount() {
        return this.getPrimaryKeys().size() + super.getChildCount();
    }

    @Override
    public int compareTo(TestcaseObject o) {
        if (!(o instanceof PersistentStateTestcase)) {
            throw new ClassCastException("o has to be an instance of " + ((Object)((Object)this)).getClass());
        }
        return super.compareTo(o);
    }

    protected TraceContainer createTraceContainer() {
        return new PersistentStateTraceContainer((Testcase)this);
    }

    public boolean loadUmlTreeFromDisk() {
        boolean loaded = false;
        this.setUmlTree(null);
        try {
            File oldDiagramFile = new File(this.getTraceFolder(), "state.diagram");
            File diagramFile = new File(this.getTraceFolder(), "state.diagram.xml");
            if (diagramFile.exists()) {
                Document traceDocument = DomUtilities.parse((Reader)this.read(diagramFile), (boolean)false, (boolean)false, (boolean)true);
                this.setUmlTree(new UmlTree(traceDocument.getDocumentElement(), this.getTraceFolder()));
            } else if (oldDiagramFile.exists()) {
                this.loadUmlTreeFromDiskOld();
            }
            UmlTree umlTree = this.getUmlTree();
            boolean bl = loaded = umlTree != null;
            if (loaded) {
                this.traceSettings.checkInspection(umlTree);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "loadUmlTree", e);
        }
        return loaded;
    }

    private void loadUmlTreeFromDiskOld() throws IOException, ParserConfigurationException, SAXException {
        NodeList traces;
        Document traceDocument = DomUtilities.parse((Reader)this.read(this.getResponseFile()), (boolean)false, (boolean)false, (boolean)true);
        if (traceDocument != null && (traces = traceDocument.getElementsByTagNameNS("http://e2e.ch/bridge", "TraceLog")) != null && traces.getLength() == 1) {
            Element trace = (Element)traces.item(0);
            this.setUmlTree(new UmlTree(trace, this.getTraceFolder()));
        }
    }
}

