/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.soap;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.event.EventController;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

abstract class Header {
    static String CRLF = "\r\n";
    private static final int CHAR_LF = 10;
    private static final int CHAR_CR = 13;
    private long contentLength;
    private String requestId;
    private byte[] headerData;

    Header(InputStream in) throws MalformedURLException {
        List<String> array = this.readLines(in);
        String firstLine = this.getFirstLine(array.get(0));
        array.remove(0);
        this.createHeader(firstLine, array);
    }

    public byte[] getHeaderData() {
        return this.headerData;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getRequestId() {
        return this.requestId;
    }

    String getFirstLine(String line) throws MalformedURLException {
        return line;
    }

    private void createHeader(String firstLine, List<String> properties) {
        StringBuilder header = new StringBuilder(firstLine);
        for (String property : properties) {
            header.append((Object)property);
        }
        header.append(CRLF);
        this.headerData = header.toString().getBytes();
    }

    private List<String> readLines(InputStream in) {
        ArrayList<String> array = new ArrayList<String>();
        try {
            int c;
            boolean endOfLine = false;
            StringBuilder buf = new StringBuilder();
            while (!((c = in.read()) == -1 || c == 10 && endOfLine)) {
                if (c == 13 && endOfLine) continue;
                if (c == 10) {
                    int index;
                    buf.append((char)c);
                    String line = buf.toString();
                    if (line.startsWith("Content-Length")) {
                        index = line.indexOf(58);
                        this.contentLength = Long.parseLong(line.substring(index + 1).trim());
                    } else if (line.startsWith("Request-ID")) {
                        index = line.indexOf(58);
                        this.requestId = line.substring(index + 1).trim();
                    }
                    array.add(line);
                    buf = new StringBuilder();
                    endOfLine = true;
                    continue;
                }
                buf.append((char)c);
                endOfLine = false;
            }
        }
        catch (IOException e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
        return array;
    }
}

