/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class TerminateView
extends UmlVertexView {
    private static final TerminateRenderer RENDERER = new TerminateRenderer();

    public TerminateView() {
    }

    public TerminateView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return this.getRenderer() instanceof TerminateRenderer ? ((TerminateRenderer)this.getRenderer()).getPerimeterPoint(this, source, p) : super.getPerimeterPoint(edge, source, p);
    }

    protected static class TerminateRenderer
    extends VertexRenderer {
        protected TerminateRenderer() {
        }

        public void paint(Graphics g) {
            int halfWidth = (int)(0.5 * (double)this.getWidth());
            int d = (int)(Math.sqrt(0.5) * (double)halfWidth);
            g.setColor(this.getBackground());
            g.drawLine(halfWidth - d, halfWidth - d, halfWidth + d, halfWidth + d);
            g.drawLine(halfWidth - d, halfWidth + d, halfWidth + d, halfWidth - d);
        }

        public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
            Rectangle2D bounds = view.getBounds();
            double width = bounds.getWidth() - 1.0;
            double height = bounds.getHeight() - 1.0;
            double xCenter = bounds.getX() + width / 2.0;
            double yCenter = bounds.getY() + height / 2.0;
            double dx = p.getX() - xCenter;
            double dy = p.getY() - yCenter;
            double angle = Math.atan2(dy, dx);
            double xOut = xCenter + width / 2.0 * Math.cos(angle);
            double yOut = yCenter + height / 2.0 * Math.sin(angle);
            return new Point2D.Double(xOut, yOut);
        }
    }
}

