/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;

public class ThrowView
extends UmlVertexView {
    private static final ThrowRenderer RENDERER = new ThrowRenderer();

    public ThrowView() {
    }

    public ThrowView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    protected static class ThrowRenderer
    extends UmlVertexView.UmlVertexRenderer {
        private int[] xBorderPoints;
        private int[] yBorderPoints;
        private int nPoints;

        protected ThrowRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            Color color = g.getColor();
            g.setColor(this.getBackground());
            int[] xPoints = new int[]{0, this.getWidth() - this.getHeight(), this.getWidth(), this.getWidth() - this.getHeight(), 0};
            int[] yPoints = new int[]{0, 0, this.getHeight() / 2, this.getHeight(), this.getHeight()};
            this.nPoints = xPoints.length;
            g.fillPolygon(xPoints, yPoints, this.nPoints);
            g.setColor(this.getBorderColor());
            this.xBorderPoints = new int[]{0, this.getWidth() - this.getHeight(), this.getWidth() - 1, this.getWidth() - this.getHeight(), 0};
            this.yBorderPoints = new int[]{0, 0, this.getHeight() / 2, this.getHeight() - 1, this.getHeight() - 1};
            g.drawPolygon(this.xBorderPoints, this.yBorderPoints, this.nPoints);
            this.setOpaque(false);
            g.setColor(color);
            super.paint(g);
        }

        @Override
        protected void paintSelectionBorder(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke previousStroke = g2.getStroke();
            if (this.childrenSelected || this.selected) {
                g2.setStroke(UmlGraphConstants.SELECTION_STROKE);
                if (this.childrenSelected) {
                    g.setColor(this.gridColor);
                } else if (this.hasFocus && this.selected) {
                    g.setColor(this.lockedHandleColor);
                } else {
                    g.setColor(this.highlightColor);
                }
                g.drawPolygon(this.xBorderPoints, this.yBorderPoints, this.nPoints);
            } else {
                g2.setStroke(previousStroke);
            }
        }

        @Override
        protected void installAttributes(CellView view) {
            super.installAttributes(view);
            this.setBorder(null);
        }
    }
}

