/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ContextMenu<T extends CellWithContextMenu>
extends JPopupMenu {
    public static final String UML_DIAGRAM_ACTION_SHOW_IN_TREE = "uml.diagram.action.show.in.tree";
    public static final String UML_DIAGRAM_ACTION_SHOW_ACTION_SCRIPT = "uml.diagram.action.show.action.script";
    public static final String UML_DIAGRAM_ACTION_SHOW_SUBACTIVITY = "uml.diagram.action.show.subactivity";
    public static final String UML_DIAGRAM_ACTION_SHOW_ADAPTER_IO = "uml.diagram.action.show.adapterIO";
    public static final String UML_DIAGRAM_ACTION_SHOW_ERROR = "uml.diagram.action.show.error";
    public static final String UML_DIAGRAM_ACTION_SHOW_ACTIVITY = "uml.diagram.action.show.activity";
    public static final String UML_DIAGRAM_ACTION_MOCK_BACKEND_MANUALLY = "uml.diagram.action.mock.backend.manually";
    public static final String UML_DIAGRAM_ACTION_SHOW_NOT_FOLLOWED_BRANCHES = "uml.diagram.action.show.not.followed.branches";
    public static final String UML_DIAGRAM_ACTION_SHOW_ITERATIONS = "uml.diagram.action.show.iterations";
    public static final String UML_DIAGRAM_ACTION_SHOW_PROCESSOR = "uml.diagram.action.show.preprocessor";
    public static final String UML_DIAGRAM_ACTION_SHOW_PARAMETERS = "uml.diagram.action.show.parameters";
    public static final String UML_DIAGRAM_ACTION_SHOW_PIN_VALUE = "uml.diagram.action.show.pin.value";
    public static final String UML_DIAGRAM_ACTION_SHOW_ENTRY_BEHAVIOR = "uml.diagram.action.show.entry.behavior";
    public static final String UML_DIAGRAM_ACTION_SHOW_STATE_BEHAVIOR = "uml.diagram.action.show.state.behavior";
    public static final String UML_DIAGRAM_ACTION_SHOW_EXIT_BEHAVIOR = "uml.diagram.action.show.exit.behavior";
    public static final String UML_DIAGRAM_ACTION_SHOW_SUBSTATE = "uml.diagram.action.show.substate";
    public static final String UML_DIAGRAM_ACTION_SHOW_MESSAGE = "uml.diagram.action.show.message";
    public static final String UML_DIAGRAM_ACTION_SHOW_VALUE = "uml.diagram.action.show.value";
    public static final KeyStroke ACCELERATOR_SHOW_IN_TREE = KeyStroke.getKeyStroke(66, 512);
    private T cell;
    private Map<String, AbstractCellAction<T>> actionMap = new HashMap<String, AbstractCellAction<T>>();
    private Map<KeyStroke, String> inputMap = new HashMap<KeyStroke, String>();
    private HashMap<String, JMenuItem> itemMap = new LinkedHashMap<String, JMenuItem>();
    private AbstractCellAction<T> defaultAction;

    public ContextMenu(T cell) {
        this.cell = cell;
    }

    public T getCell() {
        return this.cell;
    }

    public void setCell(T cell) {
        this.cell = cell;
        for (AbstractCellAction<T> action : this.actionMap.values()) {
            action.setCell(cell);
        }
    }

    public AbstractCellAction<T> getAction(KeyStroke accelerator) {
        AbstractCellAction<T> action = null;
        String actionName = this.inputMap.get(accelerator);
        if (actionName != null) {
            action = this.actionMap.get(actionName);
        }
        return action;
    }

    public AbstractCellAction<T> getDefaultAction() {
        return this.defaultAction;
    }

    public void addDefaultItem(AbstractCellAction<T> action, KeyStroke accelerator) {
        this.addItem(action, accelerator);
        this.setDefaultItem(action.getName());
    }

    public void addDefaultItem(AbstractCellAction<T> action) {
        this.addDefaultItem(action, null);
    }

    public void setDefaultItem(String name) {
        JMenuItem item;
        Font font;
        if (this.defaultAction != null && (font = (item = this.itemMap.get(this.defaultAction.getName())).getFont()).isBold()) {
            item.setFont(font.deriveFont(0));
        }
        this.defaultAction = this.actionMap.get(name);
        if (this.defaultAction != null && !(font = (item = this.itemMap.get(this.defaultAction.getName())).getFont()).isBold()) {
            item.setFont(font.deriveFont(1));
        }
    }

    public JMenuItem getItem(String name) {
        return this.itemMap.get(name);
    }

    protected String getTranslation(String key) {
        return this.getCell().getModule().getTranslation(key, key);
    }

    public void addItem(AbstractCellAction<T> action, KeyStroke accelerator) {
        this.addAction(action);
        JMenuItem item = new JMenuItem(action);
        String actionName = action.getName();
        this.itemMap.put(actionName, item);
        if (accelerator != null) {
            item.setAccelerator(accelerator);
            this.inputMap.put(accelerator, actionName);
        }
        this.add(item);
    }

    public void addItem(AbstractCellAction<T> action) {
        this.addItem(action, null);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.itemMap.put(menuItem.getText(), menuItem);
        return super.add(menuItem);
    }

    public void removeItem(String name) {
        JMenuItem item = this.itemMap.get(name);
        super.remove(item);
        this.itemMap.remove(name);
        this.actionMap.remove(name);
    }

    public void removeItem(AbstractCellAction<T> action) {
        this.removeItem(action.getName());
    }

    protected void addAction(AbstractCellAction<T> action) {
        action.setCell(this.cell);
        this.actionMap.put(action.getName(), action);
    }

    public void addItems(AbstractCellAction<T> ... actions) {
        for (AbstractCellAction<T> action : actions) {
            this.addItem(action);
        }
    }

    public void addMenu(String name, Collection<AbstractCellAction<T>> actions) {
        JMenu menu;
        JMenuItem item = this.itemMap.get(name);
        if (item instanceof JMenu) {
            menu = (JMenu)item;
            menu.removeAll();
        } else {
            menu = new JMenu(name);
            this.itemMap.put(name, menu);
            this.add(menu);
        }
        for (AbstractCellAction<T> action : actions) {
            this.addAction(action);
            menu.add(action);
        }
    }

    public void addMenu(String name, AbstractCellAction<T> ... actions) {
        this.addMenu(name, Arrays.asList(actions));
    }

    public void removeMenu(String name) {
        this.itemMap.remove(name);
    }

    public void setItemVisible(String name, boolean visible) {
        JMenuItem item = this.itemMap.get(name);
        if (item != null) {
            item.setVisible(visible);
        }
    }

    public void setItemVisible(String name, UmlObject object, boolean visible) {
        JMenuItem item = this.itemMap.get(name);
        if (item != null) {
            item.setVisible(visible);
            item.setForeground(object != null && object.hasErrors() ? Color.RED : Color.BLACK);
        }
    }

    public void setItemEnabled(String name, boolean enabled) {
        JMenuItem item = this.itemMap.get(name);
        if (item != null) {
            item.setEnabled(enabled);
        }
    }

    public void setAccelerator(String name, KeyStroke keyStroke) {
        JMenuItem item = this.itemMap.get(name);
        if (item != null) {
            item.setAccelerator(keyStroke);
        }
    }
}

