/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.util;

import ch.e2e.builder.base.util.Debouncer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DebouncerImpl
implements Debouncer {
    private static final TimeUnit INTERNAL_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final long interval;
    private ScheduledFuture<?> scheduledFuture;
    private Runnable task;
    private long lastRunTime;

    public DebouncerImpl(long interval, TimeUnit timeUnit) {
        this.interval = INTERNAL_TIME_UNIT.convert(interval, timeUnit);
    }

    @Override
    public synchronized void debounce(Runnable task) {
        this.task = task;
        if (this.needsScheduling()) {
            long delay = this.interval - (System.currentTimeMillis() - this.lastRunTime);
            if (delay < 0L) {
                this.runTask();
                delay = this.interval;
            }
            this.scheduledFuture = this.scheduler.schedule(this::runTask, delay, TimeUnit.MILLISECONDS);
        }
    }

    private boolean needsScheduling() {
        return this.scheduledFuture == null || this.scheduledFuture.isDone();
    }

    @Override
    public synchronized void flush() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.runTask();
        this.lastRunTime = 0L;
    }

    private synchronized void runTask() {
        if (this.task != null) {
            this.lastRunTime = System.currentTimeMillis();
            this.task.run();
            this.task = null;
        }
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
    }
}

