import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MatTableModule } from '@angular/material/table';
import { FormElementsModule } from '@pas/form-elements';
import { DefaultComponent } from "./components/default/default.component";
import { InstanceComponent } from "./components/instance/instance.component";
import { ProcessComponent } from "./components/process/process.component";
import { StartComponent } from "./components/start/start.component";
import { ProcessRoutingModule } from "./process.routing.module";
import { TranslateModule } from '@ngx-translate/core';
import { MatButtonModule } from "@angular/material/button";
import { MatIconModule } from "@angular/material/icon";
import { SelectTaskComponent } from "./components/select-task/select-task.component";
import { LibrariesModule } from '../../libraries.module';

@NgModule({
  declarations: [
      DefaultComponent,
      InstanceComponent,
      ProcessComponent,
      StartComponent,
      SelectTaskComponent
  ],
    imports: [
        ProcessRoutingModule,
        FormElementsModule,
        MatTableModule,
        CommonModule,
        TranslateModule,
        MatButtonModule,
        MatIconModule,
        LibrariesModule
    ],
  exports: []
})
export class ProcessModule { }
