/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import ch.e2e.util.StringTools;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexDocument
extends PlainDocument {
    private PlainDocument charDocument = new PlainDocument();
    private char emptyChar = (char)46;
    private char minChar = '\u0000';
    private char maxChar = (char)255;
    private int chars = 2;
    private boolean beepOnError;

    public HexDocument() {
        this.setRange(this.minChar, this.maxChar);
    }

    public HexDocument(char minChar, char maxChar) {
        this.minChar = minChar;
        this.maxChar = maxChar;
        this.setRange(minChar, maxChar);
    }

    @Override
    public void insertString(int offset, String insert, AttributeSet attributes) throws BadLocationException {
        String text = this.convert(offset, insert, attributes);
        super.insertString(offset, text, attributes);
    }

    public void setEmptyChar(char emptyChar) {
        this.emptyChar = emptyChar;
    }

    public void setRange(char minChar, char maxChar) {
        this.chars = Math.max(Integer.toHexString(minChar).length(), Integer.toHexString(maxChar).length());
    }

    public boolean isBeepOnError() {
        return this.beepOnError;
    }

    public void setBeepOnError(boolean beepOnError) {
        this.beepOnError = beepOnError;
    }

    public PlainDocument getCharDocument() {
        return this.charDocument;
    }

    private String convert(int offset, String text, AttributeSet attributes) throws BadLocationException {
        byte[] bytes = text.getBytes();
        StringBuffer hex = new StringBuffer(bytes.length * this.chars + 1);
        StringBuffer converted = new StringBuffer(bytes.length);
        boolean ok = true;
        for (int i = 0; i < bytes.length && ok; ++i) {
            char c;
            int charType;
            if (converted.length() > 0 && converted.length() % 2 == 0) {
                hex.append(" ");
            }
            if (this.canDisplay(charType = Character.getType(c = (char)(0xFF & bytes[i])))) {
                converted.append(String.valueOf(c));
            } else {
                converted.append(this.emptyChar);
            }
            hex.append(StringTools.prependZeros((String)Integer.toHexString(c).toUpperCase(), (int)this.chars));
        }
        this.charDocument.insertString(offset, converted.toString(), attributes);
        return hex.toString();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    private boolean canDisplay(int charType) {
        boolean canDisplay;
        switch (charType) {
            case 0: 
            case 15: {
                canDisplay = false;
                break;
            }
            default: {
                canDisplay = true;
            }
        }
        return canDisplay;
    }
}

