/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.document.RegexFieldDocument;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RegexTextField
extends JTextField
implements InputField,
DocumentListener {
    private InputFieldListener listener;
    private Color background;
    private Color disabledBackground = Color.lightGray;

    public RegexTextField(String pattern) {
        this(pattern, "");
    }

    public RegexTextField(String pattern, String text) {
        super(text);
        this.initialize(pattern);
        this.background = this.getBackground();
    }

    public RegexTextField(String pattern, int columns) {
        this(pattern, columns, -1);
    }

    public RegexTextField(String pattern, int columns, int maxLength) {
        super(columns);
        RegexFieldDocument document = this.initialize(pattern);
        document.setMaxLength(maxLength);
        this.background = this.getBackground();
    }

    public void setMaxLength(int maxLength) {
        ((RegexFieldDocument)this.getDocument()).setMaxLength(maxLength);
    }

    public void setPattern(String pattern) {
        ((RegexFieldDocument)this.getDocument()).setPattern(pattern);
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
        super.setBackground(background);
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    @Override
    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        document.addDocumentListener(this);
        super.setDocument(document);
    }

    @Override
    public Object getContent() {
        return this.getText();
    }

    @Override
    public void setContent(Object content) {
        this.setText(content == null ? "" : content.toString());
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        super.setBackground(enabled ? this.background : this.disabledBackground);
    }

    private RegexFieldDocument initialize(String pattern) {
        RegexFieldDocument document = new RegexFieldDocument(pattern);
        document.addDocumentListener(this);
        this.setDocument(document);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                int length = RegexTextField.this.getText().length();
                if (length > 0) {
                    RegexTextField.this.setSelectionStart(0);
                    RegexTextField.this.setSelectionEnd(RegexTextField.this.getText().length());
                }
            }
        });
        return document;
    }
}

