/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.DialogIcons;
import ch.e2e.swing.Message;
import ch.e2e.swing.MessageTextPane;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class QuestionDialog
extends ModalDialog {
    public static final int YES_NO = 0;
    private MultiLineLabel questionLabel;
    private int type;
    private MessageTextPane additionalInfo;
    private JScrollPane messagePane;

    public QuestionDialog(JDialog owner, int type) {
        super((Dialog)owner, " ", " ", " ", (Icon)DialogIcons.questionBigIcon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JFrame owner, int type) {
        super((Frame)owner, " ", " ", " ", (Icon)DialogIcons.questionBigIcon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JDialog owner, int type, Icon icon) {
        super((Dialog)owner, " ", " ", " ", icon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JDialog owner, String title, String internalTitle, String subtitle, int type, Icon icon) {
        super((Dialog)owner, title, internalTitle, subtitle, icon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JFrame owner, int type, Icon icon) {
        super((Frame)owner, " ", " ", " ", icon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JDialog owner, String title, int type, Icon icon) {
        super((Dialog)owner, title, " ", " ", icon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JFrame owner, String title, int type, Icon icon) {
        super((Frame)owner, title, " ", " ", icon, 3);
        this.initialize(type);
    }

    public QuestionDialog(JFrame owner, String title, String internalTitle, String subtitle, int type, Icon icon) {
        super((Frame)owner, title, internalTitle, subtitle, icon, 3);
        this.initialize(type);
    }

    public boolean doQuestion(String question) {
        this.questionLabel.setText(question);
        this.messagePane.setVisible(false);
        this.pack();
        return this.showDialog() == 1;
    }

    public boolean doQuestion(String internalTitle, String subtitle, String question) {
        this.questionLabel.setText(question);
        this.messagePane.setVisible(false);
        this.pack();
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
        this.pack();
        return this.showDialog() == 1;
    }

    public boolean doQuestion(String question, ArrayList<Message> messages) {
        this.questionLabel.setText(question);
        this.messagePane.setVisible(true);
        for (Message message : messages) {
            this.additionalInfo.appendMessage(message);
        }
        this.pack();
        return this.showDialog() == 1;
    }

    public boolean doQuestion(String internalTitle, String subtitle, String question, ArrayList<Message> messages) {
        this.questionLabel.setText(question);
        this.messagePane.setVisible(true);
        for (Message message : messages) {
            this.additionalInfo.appendMessage(message);
        }
        this.pack();
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
        this.pack();
        return this.showDialog() == 1;
    }

    public void setQuestion(String question) {
        this.questionLabel.setText(question);
        this.validate();
    }

    public void setQuestionForeground(Color foreground) {
        this.questionLabel.setForeground(foreground);
    }

    public void setQuestionFont(Font font) {
        this.questionLabel.setFont(font);
    }

    public void setQuestionLineHeight(int lineHeight) {
        this.questionLabel.setLineHeight(lineHeight);
    }

    @Override
    public void setLocale(Locale locale) {
        if (translator != null) {
            translator.setLocale(locale);
            if (this.type == 0) {
                this.setOkButtonText(translator.getTranslation("yes"));
                this.setCancelButtonText(translator.getTranslation("no"));
            } else if (this.type == 3) {
                this.setOkButtonText(translator.getTranslation("ok"));
                this.setCancelButtonText(translator.getTranslation("cancel"));
            }
        }
    }

    public void setType(int type) {
        if (type == 0) {
            this.setOkButtonText(translator.getTranslation("yes"));
            this.setCancelButtonText(translator.getTranslation("no"));
        } else if (type == 3) {
            this.setOkButtonText(translator.getTranslation("ok"));
            this.setCancelButtonText(translator.getTranslation("cancel"));
        }
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.questionLabel.setVerticalAlignment(verticalAlignment);
    }

    private void initialize(int type) {
        this.type = type;
        this.createGui();
        this.setType(type);
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(15, 10, 15, 10));
        this.questionLabel = new MultiLineLabel("", "\n", 300);
        this.questionLabel.setHorizontalAlignment(2);
        this.questionLabel.setVerticalAlignment(1);
        this.add((Component)this.questionLabel, "North");
        this.additionalInfo = new MessageTextPane("");
        this.additionalInfo.setOpaque(false);
        this.additionalInfo.setAlignmentX(0.0f);
        this.additionalInfo.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.additionalInfo.setBackground(this.getBackground());
        this.messagePane = new JScrollPane(this.additionalInfo, 20, 30);
        this.add((Component)this.messagePane, "Center");
    }
}

