/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.Message;
import ch.e2e.swing.MessagePopupMenu;
import ch.e2e.swing.MessageType;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.event.MessageGroupChangedEvent;
import ch.e2e.swing.event.MessageGroupChangedEventMulticaster;
import ch.e2e.swing.event.MessageGroupChangedListener;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class MessageGroup
extends ArrayList<Message>
implements TreeObject {
    private String name;
    private JPopupMenu popup;
    private ActionListener executeAction;
    private MessageGroupChangedListener listener;

    public MessageGroup(String name) {
        this(name, null, null);
    }

    public MessageGroup(String name, ActionListener executeAction, JPopupMenu popup) {
        this.executeAction = executeAction;
        this.name = name;
        this.popup = popup;
    }

    public void addMessageGroupChangedListener(MessageGroupChangedListener listener) {
        this.listener = MessageGroupChangedEventMulticaster.addListener(this.listener, listener);
    }

    public void removeMessageGroupChangedListener(MessageGroupChangedListener listener) {
        this.listener = MessageGroupChangedEventMulticaster.removeListener(this.listener, listener);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.listener != null) {
            this.listener.groupChanged(new MessageGroupChangedEvent(this));
        }
    }

    public ActionListener getExecuteAction() {
        return this.executeAction;
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Object getChild(int index) {
        return this.get(index);
    }

    @Override
    public int getChildCount() {
        return this.size();
    }

    public int getIndexOfChild(Object child) {
        return this.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return this.size() == 0;
    }

    @Override
    public int getType() {
        return 0;
    }

    public MessageType getMessageType() {
        MessageType result = new MessageType();
        result.type = "message.group.default.message.type";
        return result;
    }

    public MessagePopupMenu getMessagePopup(Message message) {
        return null;
    }
}

