/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.model.TestcaseResponseModel;
import ch.e2e.builder.trace.gui.testcase.DataTabbedView;
import ch.e2e.builder.trace.gui.watch.WatchRenderer;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.event.TestcaseRunFinishedEvent;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.RendererPreferences;
import java.util.EventObject;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeCellRenderer;

public class ResponseTabbedView
extends DataTabbedView {
    private long lastModified = 0L;

    public ResponseTabbedView(E2EBuilderModule module) {
        super(module, false);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ResponseTabbedView.this.refresh();
            }
        }, TestcaseRunFinishedEvent.class);
    }

    @Override
    public void setTestcase(Testcase testcase) {
        super.setTestcase(testcase);
        this.lastModified = testcase == null ? 0L : testcase.responseLastModified();
    }

    @Override
    protected String getData() {
        String data = this.getTestcase() == null ? null : this.getTestcase().getResponseData();
        return data == null ? this.module.getTranslation("testcase.no.response.exists") : data;
    }

    @Override
    protected long lastModified(Testcase testcase) {
        return this.lastModified;
    }

    @Override
    protected Tree createTree() {
        TestcaseResponseModel treeModel = new TestcaseResponseModel(this.module);
        Tree tree = new Tree((AbstractTreeModel)treeModel, (TreeCellRenderer)new WatchRenderer(new RendererPreferences((AbstractTreeModel)treeModel)));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setTransferHandler((TransferHandler)new ParameterTransferHandler());
        return tree;
    }

    @Override
    public void refresh() {
        if (this.isSelected() && this.getTestcase() != null) {
            if (this.getTestcase().isRPCEncoding()) {
                this.refreshTree(this.getTestcase());
            } else {
                this.setEditorText();
            }
        }
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.getTestcase() != null && this.getTestcase().responseLastModified() != this.lastModified) {
            this.refreshTree(this.getTestcase());
        }
        super.setSelected(selected);
    }

    private void refreshTree(Testcase testcase) {
        ((TestcaseResponseModel)((Object)this.getTree().getModel())).setRoot(testcase);
        this.getTree().refresh();
    }

    @Override
    protected void setEditorText() {
        if (!this.getTestcase().isRPCEncoding()) {
            super.setEditorText();
        }
    }
}

