/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportWsdlNameSelection
extends E2EBuilderDialog {
    private static ImportWsdlNameSelection nameSelection;
    private JList listOfExistingNames;
    private InputTextField nameField;
    private DefaultListModel namesModel;

    private ImportWsdlNameSelection(E2EBuilderModule traceViewer) {
        super(traceViewer.getTranslation("wsdl.import.select.name.title"), traceViewer.getTranslation("wsdl.import.select.name.internaltitle"), traceViewer.getTranslation("wsdl.import.select.name.subtitle"), 3);
        this.createGui(traceViewer);
        this.addEventHandler();
    }

    public static String getNewName(String defaultName, Iterable<String> existingNames, E2EBuilderModule traceViewer) {
        if (nameSelection == null) {
            nameSelection = new ImportWsdlNameSelection(traceViewer);
        }
        return nameSelection.findName(defaultName, existingNames);
    }

    private String findName(String defaultName, Iterable<String> existingNames) {
        String name = null;
        this.namesModel.clear();
        for (String existingName : existingNames) {
            this.namesModel.addElement(existingName);
        }
        this.listOfExistingNames.setSelectedValue(defaultName, true);
        this.nameField.setText(defaultName);
        this.setOkButtonEnabled(defaultName.length() > 0);
        if (this.showDialog() == 1) {
            name = this.nameField.getText();
        }
        return name;
    }

    private void createGui(E2EBuilderModule traceViewer) {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel namePanel = new JPanel(new GridLayout(2, 1));
        namePanel.add(ComponentFactory.createLabel((String)"wsdl.import.select.name.label.name", (E2EBuilderModule)traceViewer));
        this.nameField = new InputTextField();
        namePanel.add((Component)this.nameField);
        this.add(namePanel, "North");
        JPanel existingNamesPanel = new JPanel(new BorderLayout(3, 3));
        existingNamesPanel.add((Component)ComponentFactory.createLabel((String)"wsdl.import.select.name.label.existing.names", (E2EBuilderModule)traceViewer), "North");
        this.namesModel = new DefaultListModel();
        this.listOfExistingNames = new JList(this.namesModel);
        this.listOfExistingNames.setSelectionMode(0);
        existingNamesPanel.add((Component)new JScrollPane(this.listOfExistingNames, 20, 30), "Center");
        this.add(existingNamesPanel, "Center");
    }

    private void addEventHandler() {
        this.nameField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                String text = ImportWsdlNameSelection.this.nameField.getText();
                ImportWsdlNameSelection.this.setOkButtonEnabled(text.length() > 0);
                ImportWsdlNameSelection.this.listOfExistingNames.setSelectedValue(text, true);
            }
        });
        this.listOfExistingNames.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImportWsdlNameSelection.this.nameField.setText((String)ImportWsdlNameSelection.this.listOfExistingNames.getSelectedValue());
            }
        });
    }
}

