/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextField;
import ch.e2e.swing.model.SortedListModel;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringListOption;
import ch.e2e.test.options.StringOption;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StringListOptionPane
extends AbstractOptionPanel<Collection<StringOption>, StringListOption> {
    private JLabel name;
    private SortedListModel<StringOption> listModel;
    private StringListOption option;
    private JButton removeButton;
    private JList list;
    private JButton addButton;
    private InputTextField addText;
    private boolean isReadOnly = false;

    public StringListOptionPane() {
        this.createGui();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Collection<StringOption> getValue() {
        return (Collection)this.option.getValue();
    }

    @Override
    public void setValue(Collection<StringOption> value) {
    }

    @Override
    public StringListOption getOption() {
        return null;
    }

    @Override
    public void setOption(StringListOption option) {
        this.option = option;
        this.list.clearSelection();
        this.removeButton.setEnabled(false);
        this.addText.setText("");
        this.addButton.setEnabled(false);
        this.name.setText(option.getName());
        this.listModel.clear();
        this.listModel.addAll(option.getValue() == null ? (Collection)option.getDefaultValue() : (Collection)option.getValue());
    }

    @Override
    public void persist(boolean forced) {
        this.option.setValue(this.listModel.values());
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.addText.setText("");
        this.addText.setEditable(!readOnly);
        this.isReadOnly = readOnly;
    }

    @Override
    public int getWeightY() {
        return 1;
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        this.name = new JLabel();
        this.add((Component)this.name, c);
        this.addText = new InputTextField();
        c.gridwidth = 1;
        this.addText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringListOptionPane.this.addEntry();
            }
        });
        this.addText.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                StringListOptionPane.this.addButton.setEnabled(StringListOptionPane.this.addText.getText().length() > 0);
            }
        });
        this.add((Component)this.addText, c);
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.addButton = new JButton("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringListOptionPane.this.addEntry();
                StringListOptionPane.this.setChanged(true);
            }
        });
        this.add((Component)this.addButton, c);
        this.removeButton = new JButton("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringListOptionPane.this.removeEntry();
                StringListOptionPane.this.setChanged(true);
            }
        });
        c.gridwidth = 0;
        this.add((Component)this.removeButton, c);
        c.weightx = 1.0;
        this.listModel = new SortedListModel((Comparator)new Comparator<StringOption>(){

            @Override
            public int compare(StringOption t1, StringOption t2) {
                return t1.toString().compareTo(t2.toString());
            }
        });
        this.list = new JList<StringOption>((ListModel<StringOption>)this.listModel);
        this.list.setCellRenderer(new OptionListCellRenderer());
        this.list.setVisibleRowCount(3);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!StringListOptionPane.this.isReadOnly) {
                    StringListOptionPane.this.removeButton.setEnabled(StringListOptionPane.this.list.getSelectedValue() != null && !((StringOption)StringListOptionPane.this.list.getSelectedValue()).isInherited());
                }
            }
        });
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(this.list, 20, 30), c);
    }

    private void addEntry() {
        String text = this.addText.getText();
        this.addText.setText("");
        if (text.length() > 0) {
            StringOption s = new StringOption(text, text, null, this.listModel.getSize());
            s.setValue((Object)text);
            s.setInherited(false);
            this.listModel.add((Object)s);
        }
    }

    private void removeEntry() {
        this.listModel.remove((Object)((StringOption)this.list.getSelectedValue()));
    }

    private class OptionListCellRenderer
    extends DefaultListCellRenderer {
        private OptionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Option) {
                if (((Option)value).isInherited()) {
                    result.setFont(this.getFont().deriveFont(2));
                    result.setForeground(Color.DARK_GRAY);
                } else {
                    result.setFont(this.getFont().deriveFont(0));
                    result.setForeground(Color.BLACK);
                }
            }
            return result;
        }
    }
}

