/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.BooleanOptionPane;
import ch.e2e.builder.regtest.gui.swing.CompareFileOptionPane;
import ch.e2e.builder.regtest.gui.swing.FileOptionPane;
import ch.e2e.builder.regtest.gui.swing.IntegerOptionPane;
import ch.e2e.builder.regtest.gui.swing.KeyValueListOptionPane;
import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.PasswordOptionPane;
import ch.e2e.builder.regtest.gui.swing.PreprocessorOptionPane;
import ch.e2e.builder.regtest.gui.swing.StringListOptionPane;
import ch.e2e.builder.regtest.gui.swing.StringOptionPane;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.KeyValueListOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.PasswordOption;
import ch.e2e.test.options.PreprocessorOption;
import ch.e2e.test.options.StringListOption;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class OptionComponentFactory {
    private static OptionComponentFactory factory;
    private HashMap<Class<? extends Option>, Class<? extends OptionComponent>> components = new HashMap();

    private OptionComponentFactory() {
        this.registerComponent(FileOption.class, FileOptionPane.class);
        this.registerComponent(BooleanOption.class, BooleanOptionPane.class);
        this.registerComponent(StringOption.class, StringOptionPane.class);
        this.registerComponent(PasswordOption.class, PasswordOptionPane.class);
        this.registerComponent(IntegerOption.class, IntegerOptionPane.class);
        this.registerComponent(CompareFileOption.class, CompareFileOptionPane.class);
        this.registerComponent(StringListOption.class, StringListOptionPane.class);
        this.registerComponent(PreprocessorOption.class, PreprocessorOptionPane.class);
        this.registerComponent(KeyValueListOption.class, KeyValueListOptionPane.class);
    }

    public static OptionComponentFactory getInstance() {
        if (factory == null) {
            factory = new OptionComponentFactory();
        }
        return factory;
    }

    public void registerComponent(Class<? extends Option> option, Class<? extends OptionComponent> component) {
        if (!this.hasPublicDefaultConstructor(component)) {
            throw new IllegalArgumentException();
        }
        this.components.put(option, component);
    }

    public OptionComponent getOptionComponent(Option option, boolean setDefaultValue, boolean ignoreRequired) throws IllegalAccessException, InstantiationException {
        Class<? extends OptionComponent> component = this.components.get(option.getClass());
        OptionComponent result = null;
        if (component != null) {
            result = component.newInstance();
            result.setIgnoreRequired(ignoreRequired);
            result.setOption(option);
            boolean useDefaultValue = setDefaultValue && option.getValue() == null;
            result.setValue(this.value(option, useDefaultValue));
            result.setChanged(false);
        }
        return result;
    }

    private Object value(Option option, boolean useDefaultValue) {
        try {
            if (useDefaultValue) {
                if (option instanceof FileOption) {
                    File file = (File)((FileOption)option).getDefaultValue();
                    if (file == null) {
                        return null;
                    }
                    if (this.isPath(file)) {
                        return new File(file.getCanonicalPath());
                    }
                }
                return option.getDefaultValue();
            }
            if (option instanceof FileOption) {
                File file = (File)((FileOption)option).getValue();
                if (file == null) {
                    return null;
                }
                if (this.isPath(file)) {
                    return new File(file.getCanonicalPath());
                }
            }
            return option.getValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPath(File file) {
        return file.getPath().contains("/") || file.getPath().contains("\\");
    }

    private boolean hasPublicDefaultConstructor(Class<? extends OptionComponent> component) {
        boolean result = false;
        try {
            Constructor<?>[] constructors = component.getConstructors();
            for (int i = 0; i < constructors.length && !result; ++i) {
                result = constructors[i].getParameterTypes().length == 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

