/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteTreeCellRenderer;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.resource.Properties;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class OptionReplaceSelectionDialog
extends E2EBuilderDialog {
    private static OptionReplaceSelectionDialog dialog;
    private TreeModel treeModel;
    private CheckBoxTree tree;

    public OptionReplaceSelectionDialog(E2EBuilderModule module) {
        super(module.getTranslation("replace.options.selection.title"), module.getTranslation("replace.options.selection.internaltitle"), module.getTranslation("replace.options.selection.subtitle"), 3);
        this.createGui();
    }

    public static OptionReplaceSelectionDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new OptionReplaceSelectionDialog(module);
        }
        return dialog;
    }

    public List<OptionContainer> selectOptionsToReplace(TreeTestSuite testSuite, TestType type) {
        List<OptionContainer> result = null;
        PrivateTreeTestSuite root = new PrivateTreeTestSuite(testSuite, type);
        if (!root.isLeaf()) {
            this.treeModel.setRoot(root);
            this.treeModel.refresh();
            this.tree.getCheckBoxTreeSelectionModel().setSelectionPath(new TreePath(this.tree.getModel().getRoot()));
            TreeUtils.expandAll((JTree)this.tree);
            if (this.showDialog() == 1) {
                TreePath[] selection = this.tree.getCheckBoxTreeSelectionModel().getSelectionPaths();
                if (selection.length == 0) {
                    result = Collections.emptyList();
                } else {
                    result = new ArrayList();
                    for (TreePath treePath : selection) {
                        if (treePath.getLastPathComponent() instanceof OptionContainer) {
                            result.add((OptionContainer)treePath.getLastPathComponent());
                            continue;
                        }
                        this.addTestSuiteObjects((PrivateTreeTestSuite)treePath.getLastPathComponent(), result);
                    }
                }
            }
        }
        return result;
    }

    private void addTestSuiteObjects(PrivateTreeTestSuite treeTestSuite, List<OptionContainer> result) {
        for (Object object : treeTestSuite.objects) {
            if (object instanceof OptionContainer) {
                result.add((OptionContainer)object);
                continue;
            }
            this.addTestSuiteObjects((PrivateTreeTestSuite)object, result);
        }
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.treeModel = new TreeModel();
        this.tree = new CheckBoxTree((javax.swing.tree.TreeModel)((Object)this.treeModel));
        TestSuiteTreeCellRenderer renderer = new TestSuiteTreeCellRenderer(this.treeModel);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getCheckBoxTreeSelectionModel().setSelectionMode(4);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add(scrollPane);
    }

    private class TreeModel
    extends AbstractTreeModel {
        private PrivateTreeTestSuite root;

        private TreeModel() {
            super(new Properties("ch.e2e.builder.regtest.properties.tree"));
        }

        public Object getRoot() {
            return this.root;
        }

        public void setRoot(PrivateTreeTestSuite root) {
            this.root = root;
        }

        public String getTypeString(int type) {
            return null;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Object[][] getDefaultTypes() {
            return new Object[][]{{0, "regtest.root"}, {1, "regtest.testsuite"}, {2, "regtest.testsuite"}, {5, "regtest.library"}, {10, "regtest.testcase"}, {11, "regtest.testcase"}, {12, "regtest.testcase"}, {13, "regtest.testcase"}, {14, "regtest.testcase"}, {15, "regtest.testcase"}, {600, "regtest.option.container"}};
        }

        public int getType(Object value) {
            int result = value instanceof OptionContainer ? 600 : super.getType(value);
            return result;
        }

        public String toString(Object value) {
            String result = value instanceof OptionContainer ? ((OptionContainer)value).getOwner().toString() : super.toString(value);
            return result;
        }
    }

    private class PrivateTreeTestSuite
    implements TreeObject {
        private TreeTestSuite testSuite;
        private ArrayList<Object> objects;

        private PrivateTreeTestSuite(TreeTestSuite testSuite, TestType type) {
            this.testSuite = testSuite;
            this.objects = new ArrayList();
            if (!LibrariesRoot.isInLibraryTree(testSuite)) {
                for (Testable testable : testSuite.getTestcases()) {
                    PrivateTreeTestSuite suite;
                    if (testable instanceof Testcase) {
                        E2ETestResult result;
                        if (((Testcase)testable).getTest() == null) continue;
                        E2ETest test = ((Testcase)testable).getTest();
                        if (test.getType().equals(type)) {
                            this.objects.add(test);
                        }
                        if ((result = test.getResult()) == null) continue;
                        for (ResultCompare compare : result.getResultCompares()) {
                            if (!compare.getType().equals(type)) continue;
                            this.objects.add(compare);
                        }
                        continue;
                    }
                    if (!(testable instanceof TreeTestSuite) || (suite = new PrivateTreeTestSuite((TreeTestSuite)testable, type)).isLeaf()) continue;
                    this.objects.add(suite);
                }
            }
        }

        public Object getChild(int index) {
            return this.objects.get(index);
        }

        public int getChildCount() {
            return this.objects.size();
        }

        public int getIndexOfChild(Object child) {
            return this.objects.indexOf(child);
        }

        public boolean isLeaf() {
            return this.objects.size() == 0;
        }

        public int getType() {
            return this.testSuite.getType();
        }

        public String toString() {
            return this.testSuite.toString();
        }
    }
}

