/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks.typescript.libs;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.dom.DomUtilities;
import com.scheer.pas.compiler.angular.v13.Angular13Helper;
import com.scheer.pas.compiler.angular.v13.constants.Extensions;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LibraryClass2InterfaceTypescriptTask
extends CacheAbleTask {
    public static Boolean select(String id) {
        return id.endsWith(Extensions._library_interface_ts);
    }

    public LibraryClass2InterfaceTypescriptTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_interface_ts;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.project_xml);
        result.add(this.getLibraryClassesUsagesPath());
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = new HashSet<String>();
        try {
            XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
            String projectName = projectDocument.getName();
            String libraryProjectName = Angular13Helper.getLibraryProjectName(projectName);
            XSLTTransformSource source = (XSLTTransformSource)this.getSourceManager().getSource(this.getLibraryClassesUsagesPath());
            Node node = XSLTTransformSource.getNode(source.getXSLTTransformSource());
            Element model = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
            result = DomUtilities.selectNodes((Node)model, (String)"//xuml:classesUsages/xuml:classUsages/@class", this.getNamespaces()).stream().map(classNode -> classNode.getNodeValue().replace(Folders.libs, Folders.angular_projects_PROJECT_src_lib_model_libs(libraryProjectName)) + Extensions._interface_ts).collect(Collectors.toSet());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xuml", "http://scheer-group.com/xuml");
        return namespaces;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
    }

    private String getLibraryClassesUsagesPath() {
        return Folders.libs_ + this.getDestinationFileNameWithoutExtension() + Extensions._library_classes_usages_xml;
    }
}

