/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.utils.StringUtils;
import com.scheer.pas.compiler.angular.core.AngularHelper;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Angular13Helper
extends AngularHelper {
    public static final String SOURCE_TEMPLATE_ANGULAR = CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + "angular/";
    public static final String PROJECT_NAME_PATH_PLACEHOLDER = "__PROJECT_NAME__";
    public static final String INTERMEDIATE_NAME_PATH_PLACEHOLDER = "__INTERMEDIATE_NAME__";
    public static final String MODULE_NAME_PATH_PLACEHOLDER = "__MODULE_NAME__";
    public static final String PROCESS_NAME_PATH_PLACEHOLDER = "__PROCESS_NAME__";
    public static final String TASK_NAME_PATH_PLACEHOLDER = "__TASK_NAME__";
    public static final String MAIN_PROJECT_SUFFIX = "-main";
    public static final String FORM_PROJECT_SUFFIX = "-form";
    public static final String PROCESS_PROJECT_SUFFIX = "-process";
    public static final String TASK_PROJECT_SUFFIX = "-task";
    private static final Pattern DIST_PATTERN = Pattern.compile(AngularVersion.basePath_ + Folders.angular_dist_PROJECT(Angular13Helper.getMainProjectName("(.*)")) + Extensions._zip);
    private static final Pattern TASKS_PATTERN = Pattern.compile(AngularVersion.basePath_ + Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(Angular13Helper.getMainProjectName("(.*)"), "(.*)", "(.*)"));
    private static final Pattern PROCESS_PATTERN = Pattern.compile(AngularVersion.basePath_ + Folders.angular_projects_PROJECT_src_app_process_PROCESS(Angular13Helper.getMainProjectName("(.*)"), "(.*)"));
    private static final Pattern LIB_PROJECT_PATTERN = Pattern.compile(AngularVersion.basePath_ + Folders.angularLib_projects_PROJECT_("(.*)") + "(.*)");

    public static String getMainProjectName(String projectName) {
        return Angular13Helper.getAngularProjecName(projectName) + MAIN_PROJECT_SUFFIX;
    }

    public static String getFormProjectName(String projectName, String formName) {
        return Angular13Helper.getAngularProjecName(projectName) + "-" + Angular13Helper.getAngularProjecName(formName) + FORM_PROJECT_SUFFIX;
    }

    public static String getProcessProjectName(String projectName, String formName) {
        return Angular13Helper.getAngularProjecName(projectName) + "-" + Angular13Helper.getAngularProjecName(formName) + PROCESS_PROJECT_SUFFIX;
    }

    public static String getTaskProjectName(String projectName, String processName, String taskName) {
        return Angular13Helper.getAngularProjecName(projectName) + "-" + Angular13Helper.getAngularProjecName(processName) + "-" + Angular13Helper.getAngularProjecName(taskName) + TASK_PROJECT_SUFFIX;
    }

    public static String extractAngularProjectName(String id) {
        return StringUtils.substringBetween(id, Folders.angular_projects_, Folders.SEPARATOR);
    }

    public static String extractProjectName(String angularProjectName) {
        String[] names = angularProjectName.split("-");
        if (names.length > 1) {
            return names[0];
        }
        return "";
    }

    public static String extractIntermediateName(String angularProjectName) {
        String[] names = angularProjectName.split("-");
        if (names.length > 3) {
            return names[1];
        }
        return "";
    }

    public static String extractModuleName(String angularProjectName) {
        String[] names = angularProjectName.split("-");
        if (names.length == 3) {
            return names[1];
        }
        if (names.length > 3) {
            return names[2];
        }
        return "";
    }

    public static String getBaseResourceId(String id) {
        String path;
        Matcher distMatcher = DIST_PATTERN.matcher(id);
        Matcher tasksMatcher = TASKS_PATTERN.matcher(id);
        Matcher processMatcher = PROCESS_PATTERN.matcher(id);
        Matcher libraryProjectMatcher = LIB_PROJECT_PATTERN.matcher(id);
        if (distMatcher.matches()) {
            path = id.replaceFirst(distMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER);
        } else if (libraryProjectMatcher.matches()) {
            path = id.replaceFirst(libraryProjectMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER);
        } else if (tasksMatcher.matches()) {
            path = id.replaceFirst(tasksMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER).replaceFirst(tasksMatcher.group(2), PROCESS_NAME_PATH_PLACEHOLDER).replaceFirst(StringUtils.substringBefore(tasksMatcher.group(3), Folders.SEPARATOR), TASK_NAME_PATH_PLACEHOLDER);
        } else if (processMatcher.matches()) {
            path = id.replaceFirst(processMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER).replaceFirst(StringUtils.substringBefore(processMatcher.group(2), Folders.SEPARATOR), PROCESS_NAME_PATH_PLACEHOLDER);
        } else {
            String angularProjectName = Angular13Helper.extractAngularProjectName(id);
            String projectName = Angular13Helper.extractProjectName(angularProjectName);
            String intermediateName = Angular13Helper.extractIntermediateName(angularProjectName);
            String moduleName = Angular13Helper.extractModuleName(angularProjectName);
            path = Angular13Helper.replaceProjectNameInPath(id, projectName, intermediateName, moduleName);
        }
        return CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + path;
    }

    private static String replaceProjectNameInPath(String path, String projectName, String intermediateName, String moduleName) {
        if (!projectName.equals("")) {
            path = path.replaceAll(Folders.SEPARATOR + projectName, Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER);
            if (!intermediateName.equals("")) {
                path = path.replaceAll(Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + intermediateName, Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + INTERMEDIATE_NAME_PATH_PLACEHOLDER);
                if (!moduleName.equals("")) {
                    path = path.replaceAll(Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + INTERMEDIATE_NAME_PATH_PLACEHOLDER + "-" + moduleName, Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + INTERMEDIATE_NAME_PATH_PLACEHOLDER + "-" + MODULE_NAME_PATH_PLACEHOLDER);
                }
            } else if (!moduleName.equals("")) {
                path = path.replaceAll(Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + moduleName, Folders.SEPARATOR + PROJECT_NAME_PATH_PLACEHOLDER + "-" + MODULE_NAME_PATH_PLACEHOLDER);
            }
        }
        return path;
    }

    public static String extractAngularLibProjectName(String id) {
        return StringUtils.substringBetween(id, Folders.angularLib_projects_, Folders.SEPARATOR);
    }

    public static String extractAngularPath(String path) {
        return path.substring(AngularVersion.basePath_.length());
    }
}

