/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildAddedEvent;
import ch.e2e.builder.compiler.uml.ChildListener;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DependencyList;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.InvalidPropertyValueException;
import ch.e2e.builder.compiler.uml.LeftListElement;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.PropertyException;
import ch.e2e.builder.compiler.uml.Referenceable;
import ch.e2e.builder.compiler.uml.RightListElement;
import ch.e2e.builder.compiler.uml.Template;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlProperties;
import ch.e2e.swing.TreeObject;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UmlElement
implements Cloneable,
Comparable,
TreeObject,
Referenceable,
RightListElement,
LeftListElement {
    private String name;
    private Comment description;
    private BridgeStereotype stereotype;
    private ArrayList<BridgeStereotype> stereotypes;
    private UmlElement parent;
    private HashMap<BridgeStereotype, ArrayList<UmlElement>> childrensMap;
    private ArrayList<UmlElement> allChildren;
    private String xmiID;
    private Template template;
    private BridgePackage owningPackage;
    private Module module;
    private String qualifiedName;
    private HashMap<BridgeStereotype, UmlProperties> propertiesTable = new HashMap();
    private String fullQualifiedID;
    private ArrayList<UmlElement> parents;
    private Object reference;
    private String baseclass;
    private String binding;
    private Rectangle bounds;
    private Object presentation;
    private boolean editable = true;
    private ChildListener childListener;
    private boolean finalSpecialization = false;
    private ArrayList<BridgeRealization> realizations = new ArrayList();
    private DependencyList bridgeDependencies;
    private LinkedHashMap<String, Generalization> generals = new LinkedHashMap();
    private LinkedHashMap<String, BridgeOperation> operations = new LinkedHashMap();
    private LinkedHashMap<String, BridgeAttribute> attributes = new LinkedHashMap();
    private LinkedHashMap<String, BridgeAttribute> attributesWithDerived;
    private LinkedHashMap<String, BridgeOperation> operationsWithDerived;
    private Helpers helpers;

    public UmlElement(String name, Comment description, Helpers helpers) {
        this(helpers);
        this.name = name;
        this.setDescription(description);
    }

    public UmlElement(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        this(name, description, helpers);
        this.initialize(stereotype);
    }

    public UmlElement(String name, BridgeStereotype stereotype, Helpers helpers) {
        this(name, stereotype == null ? null : new Comment(stereotype.getCustomization().getElementDescription().getDefault(), helpers), stereotype, helpers);
    }

    public UmlElement(BridgeStereotype stereotype, Helpers helpers) {
        this(stereotype.getCustomization().getElementName().getDefault(), new Comment(stereotype.getCustomization().getElementDescription().getDefault(), helpers), stereotype, helpers);
    }

    protected UmlElement(Helpers helpers) {
        this.helpers = helpers;
        this.parents = new ArrayList();
        this.allChildren = new ArrayList();
    }

    public Helpers getHelpers() {
        return this.helpers;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public void createReference() throws Exception {
    }

    public Object getPresentation() {
        return this.presentation;
    }

    public void setPresentation(Object presentation) {
        this.presentation = presentation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            UmlElement parent = this;
            UmlElement owningPackage = null;
            while (parent != null && owningPackage == null) {
                String string = this.qualifiedName = this.qualifiedName == null ? parent.getName() : parent.getName() + "::" + this.qualifiedName;
                if (parent.getOwningPackage() == null) {
                    parent = parent.getParent();
                    continue;
                }
                owningPackage = parent.getOwningPackage();
            }
            while (owningPackage != null && owningPackage.getOwningPackage() != null) {
                this.qualifiedName = owningPackage.getName() + "::" + this.qualifiedName;
                owningPackage = owningPackage.getOwningPackage();
            }
        }
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public Comment getDescription() {
        return this.description;
    }

    public void setDescription(Comment description) {
        if (description != null) {
            description.setParent(this);
        }
        this.description = description;
    }

    public BridgeStereotype getStereotype() {
        return this.stereotype;
    }

    public boolean isNew() {
        return this.xmiID == null;
    }

    public UmlProperties getProperties() {
        UmlProperties umlProperties = this.stereotype == null ? new UmlProperties() : this.propertiesTable.get(this.stereotype);
        return umlProperties;
    }

    public UmlProperties getProperties(BridgeStereotype stereotype) {
        UmlProperties result = stereotype == null ? new UmlProperties() : this.propertiesTable.get(stereotype);
        return result;
    }

    public void setProperties(UmlProperties properties) {
        if (this.stereotype != null) {
            this.propertiesTable.put(this.stereotype, properties);
        }
    }

    public void setProperties(UmlProperties properties, BridgeStereotype stereotype) {
        if (stereotype != null) {
            this.propertiesTable.put(stereotype, properties);
        }
    }

    public boolean hasProperty(String propertyName) {
        boolean result = false;
        if (this.stereotypes != null) {
            int length = this.stereotypes.size();
            for (int i = 0; i < length && !result; ++i) {
                BridgeStereotype stereotype = this.stereotypes.get(i);
                result = this.propertiesTable.get(stereotype).get(propertyName) != null;
            }
        }
        return result;
    }

    public Object getPropertyValue(String propertyName) throws NoSuchPropertyException {
        Object result;
        if (this.stereotypes == null) {
            result = this.getProperty(propertyName).getValue();
        } else {
            Property property = (Property)this.propertiesTable.get(this.getStereotype()).get(propertyName);
            result = property == null ? null : property.getValue();
            int length = this.stereotypes.size();
            for (int i = 0; i < length && result == null; ++i) {
                BridgeStereotype stereotype = this.stereotypes.get(i);
                property = (Property)this.propertiesTable.get(stereotype).get(propertyName);
                if (property == null || property.isEmpty()) continue;
                result = property.getValue();
            }
        }
        return result;
    }

    public Object getPropertyValueQuietly(String propertyName) {
        Object value = null;
        try {
            value = this.getProperty(propertyName).getValue();
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        return value;
    }

    public void setPropertyValue(String propertyName, Object value) throws NoSuchPropertyException, InvalidPropertyValueException {
        Property p = this.getProperty(propertyName);
        p.setValue(value);
    }

    public void setPropertyValueQuietly(String propertyName, Object value) {
        try {
            this.setPropertyValue(propertyName, value);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public Property getProperty(String propertyName, BridgeStereotype stereotype) throws NoSuchPropertyException {
        Property result = null;
        if (stereotype != null && this.propertiesTable.get(stereotype) != null) {
            result = (Property)this.propertiesTable.get(stereotype).get(propertyName);
        }
        if (result == null) {
            throw new NoSuchPropertyException(this.name, propertyName);
        }
        return result;
    }

    public Property getProperty(String propertyName) throws NoSuchPropertyException {
        Property result = null;
        if (this.stereotypes != null) {
            int length = this.stereotypes.size();
            for (int i = 0; i < length && result == null; ++i) {
                BridgeStereotype stereotype = this.stereotypes.get(i);
                result = (Property)this.propertiesTable.get(stereotype).get(propertyName);
            }
        }
        if (result == null) {
            throw new NoSuchPropertyException(this.name, propertyName);
        }
        return result;
    }

    public HashMap<String, PropertyDefinition> getPropertyDefinitions() {
        return this.stereotype == null ? null : this.stereotype.getPropertyDefinitions();
    }

    public boolean isSelectable() {
        return this.stereotype == null || this.stereotype.getCustomization().getChildren().size() > 0;
    }

    public String toString() {
        return this.getName();
    }

    public void addChild(UmlElement child) {
        if (!this.allChildren.contains(child)) {
            this.allChildren.add(child);
            child.setParent(this);
            child.setOwningPackage(null);
            this.getChildren().add(child);
            this.informChildListener(child);
        }
    }

    public void removeChild(UmlElement child) {
        child.removeParent(this);
        this.allChildren.remove(child);
        for (ArrayList<UmlElement> list : this.childrensMap.values()) {
            list.remove(child);
        }
    }

    public void removeAllChildren() {
        for (UmlElement child : this.allChildren) {
            this.removeChild(child);
        }
    }

    public boolean hasChildren() {
        return this.childrensMap != null && this.childrensMap.get(this.getStereotype()).size() > 0;
    }

    public List<UmlElement> getChildren() {
        return this.childrensMap == null ? new ArrayList<UmlElement>() : (List)this.childrensMap.get(this.getStereotype());
    }

    public ArrayList<UmlElement> getAllChildren() {
        return this.allChildren;
    }

    public void setAllChildren(ArrayList<UmlElement> allChildren) {
        this.allChildren = allChildren;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isVisible() {
        boolean result = true;
        if (this.stereotypes != null) {
            int length = this.stereotypes.size();
            for (int i = 0; i < length && result; ++i) {
                result = this.stereotypes.get(i).isVisible();
            }
        }
        return result;
    }

    public boolean isFinalSpecialization() {
        return this.finalSpecialization;
    }

    public void setFinalSpecialization(boolean finalSpecialization) {
        this.finalSpecialization = finalSpecialization;
    }

    public ArrayList<BridgeRealization> getBridgeRealizations() {
        return this.realizations;
    }

    public void addRealization(BridgeRealization realization) {
        this.realizations.add(realization);
    }

    public BridgeRealization getRealization(int index) {
        try {
            return this.realizations.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setChildren(ArrayList<UmlElement> children) {
        for (UmlElement child : children) {
            this.addChild(child);
        }
    }

    protected HashMap<BridgeStereotype, ArrayList<UmlElement>> getChildrensMap() {
        return this.childrensMap;
    }

    public UmlElement getParent() {
        return this.parent;
    }

    public void removeParent(UmlElement parent) {
        this.parents.remove(parent);
        if (this.parents.size() == 0) {
            this.setParent(null);
        } else {
            this.setParent(this.parents.get(0));
        }
    }

    public void setParent(UmlElement parent) {
        this.parent = parent;
        if (parent != null && !this.parents.contains(parent)) {
            this.parents.add(parent);
        }
    }

    @Override
    public String toDisplayText() {
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return this.stereotype == null ? null : this.stereotype.getCustomization().getIcon();
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public BridgeStereotype getChildBridgeStereotype(String stereotype) {
        BridgeStereotype type;
        int j;
        int childCount;
        ArrayList<BridgeStereotype> children;
        BridgeStereotype bridgeStereotype;
        int i;
        BridgeStereotype result = null;
        int length = this.stereotypes.size();
        for (i = 0; i < length && result == null; ++i) {
            bridgeStereotype = this.stereotypes.get(i);
            children = bridgeStereotype.getCustomization().getChildren();
            childCount = children.size();
            for (j = 0; j < childCount && result == null; ++j) {
                type = children.get(j);
                if (!type.getName().equals(stereotype)) continue;
                result = type;
            }
        }
        if (result == null) {
            for (i = 0; i < length && result == null; ++i) {
                bridgeStereotype = this.stereotypes.get(i);
                if (bridgeStereotype.getDeploymentType() == null) continue;
                children = bridgeStereotype.getDeploymentType().getCustomization().getChildren();
                childCount = children.size();
                for (j = 0; j < childCount && result == null; ++j) {
                    type = children.get(j);
                    if (!type.getName().equals(stereotype)) continue;
                    result = type;
                }
            }
        }
        return result;
    }

    public ArrayList<BridgeStereotype> getStereotypes() {
        return this.stereotypes;
    }

    public void addStereotype(BridgeStereotype stereotype) {
        if (this.stereotypes == null) {
            this.initialize(stereotype);
        } else if (!this.stereotypes.contains(stereotype)) {
            this.stereotypes.add(stereotype);
            ArrayList children = new ArrayList();
            this.childrensMap.put(stereotype, children);
            this.setupProperties(stereotype);
        }
    }

    public void setStereotype(BridgeStereotype stereotype) {
        if (this.stereotypes == null) {
            this.initialize(stereotype);
        } else if (stereotype != null) {
            if (this.stereotypes.contains(stereotype)) {
                this.propertiesTable.get(stereotype).checkDependencies();
            } else {
                this.addStereotype(stereotype);
            }
        }
        this.stereotype = stereotype;
    }

    public void removeStereotype(BridgeStereotype stereotype) {
        if (this.stereotypes != null) {
            this.stereotypes.remove(stereotype);
            this.propertiesTable.remove(stereotype);
            if (this.stereotypes.size() == 0) {
                this.stereotype = null;
            } else {
                this.setStereotype(this.stereotypes.get(0));
            }
        }
    }

    public boolean hasStereotype(BridgeStereotype stereotype) {
        return this.stereotypes != null && this.stereotypes.contains(stereotype);
    }

    public ChildListener getChildListener() {
        return this.childListener;
    }

    public void setChildListener(ChildListener childListener) {
        this.childListener = childListener;
        for (UmlElement umlElement : this.getChildren()) {
            umlElement.setChildListener(childListener);
        }
    }

    public Collection<Generalization> getGenerals() {
        return this.generals.values();
    }

    public Generalization getGeneral(String name) {
        return this.generals.get(name);
    }

    public boolean hasGeneral(String name) {
        return this.generals.containsKey(name);
    }

    public void addGeneral(Generalization general) {
        this.generals.put(general.getQualifiedName(), general);
        general.setModule(this.getModule());
    }

    public void addAttribute(BridgeAttribute attribute) {
        attribute.setParent(this);
        this.attributes.put(attribute.getName(), attribute);
    }

    public void removeAttribute(BridgeAttribute attribute) {
        attribute.setParent(null);
        this.attributes.remove(attribute.getName());
    }

    public Collection<BridgeAttribute> getAttributes() {
        return this.attributes.values();
    }

    public LinkedHashMap<String, BridgeAttribute> getAttributesMap() {
        return this.attributes;
    }

    public void setAttributesMap(LinkedHashMap<String, BridgeAttribute> attributes) {
        this.attributes = attributes;
    }

    public Collection<BridgeAttribute> getAttributesWithDerived() {
        return this.setupAttributesWithDerived().values();
    }

    public Map<String, BridgeAttribute> setupAttributesWithDerived() {
        if (this.attributesWithDerived == null) {
            this.attributesWithDerived = new LinkedHashMap();
            for (Generalization generalization : this.getGenerals()) {
                this.attributesWithDerived.putAll(generalization.setupAttributesWithDerived());
            }
            for (Map.Entry entry : this.attributes.entrySet()) {
                this.attributesWithDerived.put((String)entry.getKey(), (BridgeAttribute)entry.getValue());
            }
        }
        return this.attributesWithDerived;
    }

    public BridgeAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public BridgeAttribute getAttributeWithDerived(String name) {
        return this.setupAttributesWithDerived().get(name);
    }

    public void addOperation(BridgeOperation operation) {
        operation.setParent(this);
        this.operations.put(operation.getSignature(), operation);
    }

    public void removeOperation(BridgeOperation operation) {
        operation.setParent(null);
        this.operations.remove(operation.getSignature());
    }

    public Collection<BridgeOperation> getOperations() {
        return this.operations.values();
    }

    public LinkedHashMap<String, BridgeOperation> getOperationsMap() {
        return this.operations;
    }

    public void setOperationsMap(LinkedHashMap<String, BridgeOperation> operations) {
        this.operations = operations;
    }

    public Collection<BridgeOperation> getOperations(Boolean staticOps) {
        if (staticOps == null) {
            return this.getOperations();
        }
        if (staticOps.booleanValue()) {
            return this.getStaticOperations();
        }
        return this.getNonStaticOperations();
    }

    public List<BridgeOperation> getNonStaticOperations() {
        ArrayList<BridgeOperation> nonStaticOperations = new ArrayList<BridgeOperation>();
        for (BridgeOperation operation : this.operations.values()) {
            if (operation.isStatic()) continue;
            nonStaticOperations.add(operation);
        }
        return nonStaticOperations;
    }

    public List<BridgeOperation> getStaticOperations() {
        ArrayList<BridgeOperation> staticOperations = new ArrayList<BridgeOperation>();
        for (BridgeOperation operation : this.operations.values()) {
            if (!operation.isStatic()) continue;
            staticOperations.add(operation);
        }
        return staticOperations;
    }

    public Collection<BridgeOperation> getOperationsWithDerived() {
        return this.setupOperationsWithDerived().values();
    }

    public Collection<BridgeOperation> getOperationsWithDerived(Boolean staticOps) {
        if (staticOps == null) {
            return this.getOperationsWithDerived();
        }
        if (staticOps.booleanValue()) {
            return this.getStaticOperationsWithDerived();
        }
        return this.getNonStaticOperationsWithDerived();
    }

    public List<BridgeOperation> getNonStaticOperationsWithDerived() {
        ArrayList<BridgeOperation> nonStaticOperations = new ArrayList<BridgeOperation>();
        for (BridgeOperation operation : this.getOperationsWithDerived()) {
            if (operation.isStatic()) continue;
            nonStaticOperations.add(operation);
        }
        return nonStaticOperations;
    }

    public List<BridgeOperation> getStaticOperationsWithDerived() {
        ArrayList<BridgeOperation> staticOperations = new ArrayList<BridgeOperation>();
        for (BridgeOperation operation : this.getOperationsWithDerived()) {
            if (!operation.isStatic()) continue;
            staticOperations.add(operation);
        }
        return staticOperations;
    }

    public Map<String, BridgeOperation> setupOperationsWithDerived() {
        if (this.operationsWithDerived == null) {
            this.operationsWithDerived = new LinkedHashMap();
            this.operationsWithDerived.putAll(this.helpers.getElementHelper().findType("Base Types/Any").setupOperationsWithDerived());
            for (Generalization generalization : this.getGenerals()) {
                this.operationsWithDerived.putAll(generalization.setupOperationsWithDerived());
            }
            for (Map.Entry entry : this.operations.entrySet()) {
                this.operationsWithDerived.put((String)entry.getKey(), (BridgeOperation)entry.getValue());
            }
        }
        return this.operationsWithDerived;
    }

    public BridgeOperation getOperation(String name) {
        return this.operations.get(name);
    }

    public BridgeOperation getOperationWithDerived(String name) {
        return this.setupOperationsWithDerived().get(name);
    }

    public List<TypedElement> getElements() {
        ArrayList<TypedElement> elements = new ArrayList<TypedElement>();
        elements.addAll(this.getAttributes());
        elements.addAll(this.getOperations());
        for (Generalization generalization : this.getGenerals()) {
            elements.addAll(generalization.getElements());
        }
        return elements;
    }

    public List<TypedElement> getElementsWithDerived() {
        ArrayList<TypedElement> elements = new ArrayList<TypedElement>();
        elements.addAll(this.getAttributesWithDerived());
        elements.addAll(this.getOperationsWithDerived());
        return elements;
    }

    public TypedElement getElement(String name) {
        BridgeAttribute found = this.getAttribute(name);
        return found == null ? this.getOperation(name) : found;
    }

    public TypedElement getElementWithDerived(String name) {
        BridgeAttribute element = this.getAttributeWithDerived(name);
        return element == null ? this.getOperationWithDerived(name) : element;
    }

    protected void informChildListener(UmlElement child) {
        child.setChildListener(this.getChildListener());
        if (this.getChildListener() != null) {
            this.getChildListener().childAdded(new ChildAddedEvent(this, child));
        }
    }

    private void initialize(BridgeStereotype stereotype) {
        if (stereotype != null) {
            this.stereotypes = new ArrayList();
            this.childrensMap = new HashMap();
            this.addStereotype(stereotype);
            this.setStereotype(stereotype);
            this.setBaseclass(stereotype.getDefaultBaseclass());
            this.setupProperties(stereotype);
            this.bridgeDependencies = new DependencyList(this, this.getHelpers());
            this.bridgeDependencies.setSelectable(false);
        }
    }

    private void setupProperties(BridgeStereotype stereotype) {
        HashMap<String, PropertyDefinition> propDefs;
        UmlProperties properties = this.propertiesTable.get(stereotype);
        if (properties == null) {
            properties = new UmlProperties();
            this.propertiesTable.put(stereotype, properties);
        }
        if ((propDefs = stereotype.getPropertyDefinitions()) != null) {
            for (PropertyDefinition d : propDefs.values()) {
                if (properties.hasProperty(d.getName())) continue;
                properties.addProperty(d.createProperty());
            }
            properties.checkDependencies();
        }
    }

    void addProperty(Property property) {
        this.getProperties().addProperty(property);
    }

    public int compareTo(Object o) {
        return o instanceof UmlElement ? this.getName().compareToIgnoreCase(((UmlElement)o).getName()) : 0;
    }

    public String getXmiID() {
        if (this.xmiID == null || this.xmiID.length() == 0) {
            this.xmiID = this.helpers.getXmiIDFactory().getXmiID(this.getIdKey(), this.getBaseclass());
        }
        return this.xmiID;
    }

    public void setXmiID(String xmiID) {
        this.xmiID = xmiID == null ? null : xmiID.replace(' ', '_');
    }

    public BridgePackage getOwningPackage() {
        return this.owningPackage;
    }

    public void setOwningPackage(BridgePackage owningPackage) {
        this.owningPackage = owningPackage;
    }

    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element = this.createXMIElement(this.getXMIElementName(), ownerDocument, xmiIDFactory);
        this.appendChildXMIElements(ownerDocument, element, xmiIDFactory);
        this.addGeneralizations(element, ownerDocument, xmiIDFactory);
        return element;
    }

    protected void appendChildXMIElements(Document ownerDocument, Element element, XmiIDFactory xmiIDFactory) {
        if (this.allChildren != null) {
            for (UmlElement umlElement : this.allChildren) {
                element.appendChild(umlElement.toChildXMI(ownerDocument, xmiIDFactory));
            }
        }
    }

    public UmlElement[] getAdditionalElements() {
        return new UmlElement[0];
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return this.getStereotype() != null && this.getStereotype().getCustomizationProperty("multipleInstancesAllowed") != null && (Boolean)this.getStereotype().getCustomizationProperty("multipleInstancesAllowed") != false;
    }

    protected String getXMIElementName() {
        return "packagedElement";
    }

    protected Element createXMIElement(String elementName, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element = ownerDocument.createElement(elementName);
        element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.getBaseclass());
        String name = this.getName();
        if (name != null) {
            element.setAttribute("name", name);
        }
        element.setAttribute("visibility", "public");
        element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID());
        this.appendDescription(element, ownerDocument, xmiIDFactory);
        return element;
    }

    protected void appendDescription(Element element, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        if (this.description != null) {
            element.appendChild(this.description.toXMI(ownerDocument, xmiIDFactory));
        }
    }

    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element realization = ownerDocument.createElement("realization");
        realization.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", this.getParent().getRealizationType());
        realization.setAttribute("visibility", "private");
        realization.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID() + "_realization");
        Element supplier = ownerDocument.createElement("supplier");
        supplier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getParent().getXmiID());
        realization.appendChild(supplier);
        if (this.checkModule(this.parent.getModule())) {
            Element client = ownerDocument.createElement("client");
            client.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
            realization.appendChild(client);
            Element realizingClassifier = ownerDocument.createElement("realizingClassifier");
            realizingClassifier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
            realization.appendChild(realizingClassifier);
        } else {
            Element client = this.createModuleLink("client", "Class", this.getXmiID(), this.getModule(), ownerDocument, xmiIDFactory);
            realization.appendChild(client);
            Element realizingClassifier = this.createModuleLink("realizingClassifier", "Class", this.getXmiID(), this.getModule(), ownerDocument, xmiIDFactory);
            realization.appendChild(realizingClassifier);
        }
        return realization;
    }

    protected Element createNestedArtifactChild(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element nestedArtifact = ownerDocument.createElement(this.parent instanceof DeploymentElement ? "nestedArtifact" : "packagedElement");
        nestedArtifact.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.getBaseclass());
        nestedArtifact.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID());
        nestedArtifact.setAttribute("visibility", "public");
        nestedArtifact.setAttribute("name", this.getName());
        if (this.getDescription() != null) {
            nestedArtifact.appendChild(this.getDescription().toXMI(ownerDocument, xmiIDFactory));
        }
        for (UmlElement umlElement : this.getChildren()) {
            DeploymentElement child = (DeploymentElement)umlElement;
            nestedArtifact.appendChild(child.toChildXMI(ownerDocument, xmiIDFactory));
        }
        return nestedArtifact;
    }

    public String getBaseclass() {
        return this.baseclass;
    }

    public void setBaseclass(String baseclass) {
        if (baseclass != null) {
            this.baseclass = baseclass;
        }
    }

    protected String getRealizationType() {
        return "uml:ComponentRealization";
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public boolean isChildRequired() {
        BridgeStereotype stereotype = this.getStereotype();
        return this.isChildRequired(stereotype);
    }

    protected boolean isChildRequired(BridgeStereotype stereotype) {
        Boolean childRequired = (Boolean)stereotype.getCustomization().getProperty("childRequired");
        if (childRequired == null && stereotype.getDeploymentType() != null) {
            childRequired = (Boolean)stereotype.getDeploymentType().getCustomization().getProperty("childRequired");
        }
        return childRequired == null ? false : childRequired;
    }

    public UmlElement clone() {
        UmlElement clone;
        try {
            clone = (UmlElement)super.clone();
            clone.propertiesTable = new HashMap();
            for (BridgeStereotype stereotype : this.propertiesTable.keySet()) {
                clone.propertiesTable.put(stereotype, (UmlProperties)this.propertiesTable.get(stereotype).clone());
            }
            for (UmlElement child : clone.getAllChildren()) {
                child.setParent(clone);
            }
            if (this.description != null) {
                this.description.setParent(clone);
            }
        }
        catch (CloneNotSupportedException e) {
            clone = this;
        }
        return clone;
    }

    public UmlElement createCopy() {
        UmlElement copy;
        try {
            copy = (UmlElement)super.clone();
            copy.propertiesTable = (HashMap)this.propertiesTable.clone();
            copy.childrensMap = new HashMap<BridgeStereotype, ArrayList<UmlElement>>(this.childrensMap);
            for (BridgeStereotype bridgeStereotype : this.childrensMap.keySet()) {
                copy.childrensMap.put(bridgeStereotype, new ArrayList(this.childrensMap.get(bridgeStereotype)));
            }
            copy.allChildren = new ArrayList<UmlElement>(this.allChildren);
            if (this.description != null) {
                copy.setDescription(new Comment(this.description.getText(), this.getHelpers()));
            }
            copy.setParent(null);
            copy.setXmiID(null);
            this.checkXmiIdAndChildrenOfCopy(copy);
        }
        catch (CloneNotSupportedException e) {
            copy = this;
        }
        return copy;
    }

    protected void checkXmiIdAndChildrenOfCopy(UmlElement copy) {
        ArrayList<UmlElement> children = new ArrayList<UmlElement>(copy.getAllChildren());
        for (UmlElement child : children) {
            if (child.getOwningPackage() == null) {
                UmlElement copiedChild = child.createCopy();
                copiedChild.setXmiID(null);
                UmlElement parent = child.getParent();
                copy.removeChild(child);
                child.setParent(parent);
                copy.addChild(copiedChild);
                child = copiedChild;
            }
            this.checkXmiIdAndChildrenOfCopy(child);
        }
    }

    public int getType() {
        return 0;
    }

    public int getIndexOfChild(Object child) {
        int index = this.getStereotype().getCustomization().hasBridgeDependencies() ? (child.equals(this.bridgeDependencies) ? 0 : this.allChildren.indexOf(child) + 1) : this.allChildren.indexOf(child);
        return index;
    }

    public int getChildCount() {
        return this.getStereotype() != null && this.getStereotype().getCustomization().hasBridgeDependencies() ? this.allChildren.size() + 1 : this.allChildren.size();
    }

    public UmlElement getChild(int index) {
        UmlElement result = this.getStereotype().getCustomization().hasBridgeDependencies() ? (index == 0 ? this.bridgeDependencies : this.allChildren.get(index - 1)) : this.allChildren.get(index);
        return result;
    }

    public boolean isLeaf() {
        return this.allChildren.size() == 0;
    }

    public UmlElement createReference(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        String fullQualifiedID = parent.getFullQualifiedID() + '.' + this.getXmiID();
        UmlElement result = referenceObjects.get(fullQualifiedID);
        if (result == null) {
            result = this.createReferenceObject(referenceObjects, parent);
            result.setXmiID(this.getXmiID());
            result.setFullQualifiedID(fullQualifiedID);
            result.propertiesTable = this.propertiesTable;
            result.setOwningPackage(this.getOwningPackage());
            result.setModule(this.getModule());
            result.setTemplate(this.template);
            result.setReference(this.getReference());
            result.setPresentation(this.getPresentation());
            result.setBounds(this.getBounds());
            for (UmlElement child : this.getChildren()) {
                result.addChild(child.createReference(referenceObjects, result));
            }
            referenceObjects.put(fullQualifiedID, result);
        }
        return result;
    }

    public String getFullQualifiedID() {
        if (this.fullQualifiedID == null) {
            this.fullQualifiedID = this.getXmiID();
            for (UmlElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
                this.fullQualifiedID = parent.getXmiID() + '.' + this.fullQualifiedID;
            }
        }
        return this.getXmiID();
    }

    public void setFullQualifiedID(String fullQualifiedID) {
        this.fullQualifiedID = fullQualifiedID;
    }

    public List<Module> getAllUsedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        if (this.getModule() != null) {
            result.add(this.getModule());
        }
        for (UmlElement child : this.allChildren) {
            List<Module> allModules = child.getAllUsedModules();
            for (Module module : allModules) {
                if (result.contains(module)) continue;
                result.add(module);
            }
        }
        return result;
    }

    public List<UmlElement> getAllChildrenUsingOtherModule() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (UmlElement child : this.allChildren) {
            if (!this.checkModule(child.getModule())) {
                result.add(child);
            }
            List<UmlElement> children = child.getAllChildrenUsingOtherModule();
            for (UmlElement testChild : children) {
                if (this.checkModule(testChild.getModule()) || result.contains(testChild)) continue;
                result.add(testChild);
            }
        }
        return result;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public boolean isComplete() {
        boolean complete;
        boolean bl = complete = !this.isChildRequired();
        if (!complete) {
            List<UmlElement> children = this.getChildren();
            int length = children.size();
            complete = length > 0;
            for (int i = 0; i < length && complete; ++i) {
                complete = children.get(i).isComplete();
            }
        }
        return complete;
    }

    public boolean isChildSelectionEnabled() {
        Boolean childSelectionEnabled = (Boolean)this.getStereotype().getCustomization().getProperty("childSelectionEnabled");
        return childSelectionEnabled == null || childSelectionEnabled != false;
    }

    public boolean containsChildOfType(ClassifierElement classifierElement) {
        boolean result = false;
        int length = this.getChildren().size();
        for (int i = 0; i < length && !result; ++i) {
            UmlElement child = this.getChildren().get(i);
            result = child.equals(classifierElement);
        }
        return result;
    }

    public boolean containsChildOfType(BridgeStereotype stereotype) {
        boolean result = false;
        int length = this.getChildren().size();
        for (int i = 0; i < length && !result; ++i) {
            result = this.getChildren().get(i).getStereotype().equals(stereotype);
        }
        return result;
    }

    @Override
    public boolean isRequired() {
        return this.getStereotype().isRequired();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void addDependency(BridgeDependency dependency) {
        if (!this.bridgeDependencies.contains(dependency)) {
            this.bridgeDependencies.add(dependency);
            dependency.setParent(this);
        }
    }

    public DependencyList getBridgeDependencies() {
        return this.bridgeDependencies;
    }

    public boolean containsDependency(BridgeStereotype dependencyType) {
        boolean result = false;
        int length = this.bridgeDependencies.size();
        for (int i = 0; i < length && !result; ++i) {
            BridgeDependency dependency = this.bridgeDependencies.get(i);
            result = dependency.getStereotype().equals(dependencyType);
        }
        return result;
    }

    protected UmlElement createReferenceObject(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        UmlElement result = new UmlElement(this.getName(), this.getDescription(), this.getStereotype(), this.helpers);
        result.bridgeDependencies = this.bridgeDependencies;
        return result;
    }

    protected String getIdKey() {
        StringBuilder result = new StringBuilder().append(this.toString());
        BridgePackage owningPackage = null;
        for (UmlElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result.insert(0, parent.getName());
            owningPackage = parent.getOwningPackage();
        }
        result.insert(0, this.getOwningPackageKey(owningPackage));
        return result.toString();
    }

    protected String getOwningPackageKey(BridgePackage owningPackage) {
        String owningPackageKey;
        if (owningPackage == null) {
            owningPackage = this.getOwningPackage();
        }
        if (owningPackage == null) {
            owningPackageKey = "";
        } else {
            String root;
            owningPackageKey = owningPackage.getKey();
            if (owningPackageKey.startsWith(root = this.helpers.getPackagesFactory().getRootPackage().getName())) {
                owningPackageKey = "null" + owningPackageKey.substring(root.length());
            }
        }
        return owningPackageKey;
    }

    protected Element createModuleLink(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.createModuleLink(this.getXMIElementName(), this.getBaseclass(), this.getXmiID(), this.getModule(), ownerDocument, xmiIDFactory);
    }

    protected Element createModuleLink(String elementName, String baseclass, String xmiID, Module module, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = ownerDocument.createElement(elementName);
        result.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + baseclass);
        result.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "href", module.getName() + '#' + xmiID);
        Element xmiExtension = ownerDocument.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
        xmiExtension.setAttribute("extender", module.getExtender() + ' ' + module.getExtenderVersion());
        Element referenceExtension = ownerDocument.createElement("referenceExtension");
        referenceExtension.setAttribute("referentPath", this.getQualifiedName());
        referenceExtension.setAttribute("referentType", baseclass);
        xmiExtension.appendChild(referenceExtension);
        result.appendChild(xmiExtension);
        return result;
    }

    protected Element createModuleLink(UmlElement umlElement, String elementName, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Module module = umlElement.getModule();
        Element result = ownerDocument.createElement(elementName);
        result.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + umlElement.getBaseclass());
        result.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "href", module.getName() + '#' + umlElement.getXmiID());
        Element xmiExtension = ownerDocument.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
        xmiExtension.setAttribute("extender", module.getExtender() + ' ' + module.getExtenderVersion());
        Element referenceExtension = ownerDocument.createElement("referenceExtension");
        referenceExtension.setAttribute("referentPath", umlElement.getQualifiedName());
        referenceExtension.setAttribute("referentType", umlElement.getBaseclass());
        xmiExtension.appendChild(referenceExtension);
        result.appendChild(xmiExtension);
        return result;
    }

    protected boolean checkModule(Module module) {
        return this.getModule() == null && module == null || this.getModule() != null && this.getModule().equals(module);
    }

    private void addGeneralizations(Element clazz, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        for (Generalization general : this.getGenerals()) {
            clazz.appendChild(general.toXMI(this, ownerDocument, xmiIDFactory));
        }
    }

    protected void copyStereotypesAndProperties(UmlElement result) {
        if (this.getStereotypes() != null) {
            for (BridgeStereotype stereotype : this.getStereotypes()) {
                result.addStereotype(stereotype);
                result.setProperties(this.getProperties(stereotype), stereotype);
            }
        }
    }
}

