/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class JavaImportTools {
    public static String findBridgeType(Class clazz) {
        String bridgeType = null;
        if (clazz != null) {
            String javaType = clazz.getName();
            if (clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                bridgeType = "Array";
            } else if (javaType.equals("java.lang.Byte") || javaType.equals("byte") || javaType.equals("java.lang.Short") || javaType.equals("short") || javaType.equals("java.lang.Integer") || javaType.equals("int") || javaType.equals("java.lang.Long") || javaType.equals("long") || javaType.equals("java.math.BigInteger")) {
                bridgeType = "Integer";
            } else if (javaType.equals("java.lang.Double") || javaType.equals("double") || javaType.equals("java.lang.Float") || javaType.equals("float") || javaType.equals("java.math.BigDecimal")) {
                bridgeType = "Float";
            } else if (javaType.equals("java.lang.String") || javaType.equals("java.lang.StringBuffer") || javaType.equals("java.lang.StringBuilder") || javaType.equals("java.lang.Character") || javaType.equals("char")) {
                bridgeType = "String";
            } else if (javaType.equals("java.lang.Boolean") || javaType.equals("boolean")) {
                bridgeType = "Boolean";
            } else if (javaType.equals("java.lang.Boolean") || javaType.equals("boolean")) {
                bridgeType = "Boolean";
            } else if (Date.class.isAssignableFrom(clazz) || GregorianCalendar.class.isAssignableFrom(clazz)) {
                bridgeType = "DateTime";
            } else if (InputStream.class.isAssignableFrom(clazz) || byte[].class.isAssignableFrom(clazz) || Byte[].class.isAssignableFrom(clazz)) {
                bridgeType = "Blob";
            }
        }
        return bridgeType;
    }
}

