/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.edmx;

import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.edmx.EDMXImportSource;
import ch.e2e.builder.compiler.document.importer.idl.IDLTransformImportTransaction;
import ch.e2e.builder.compiler.uml.Helpers;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EdmxImportTransaction
extends IDLTransformImportTransaction {
    public static final String EDMX_DOCUMENT_SOURCE = "edmx.document.source";
    public static final String EDMX_IMPORT_MODELS = "edmx.import.model";
    public static final String EDMX_ONLY_ENTITIES_PARAM_KEY = "onlyEntities";
    private File importsFolder;
    private final String description;

    EdmxImportTransaction(File importsFolder, String description, Helpers helpers) {
        super(helpers);
        this.importsFolder = importsFolder;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected String getScript() {
        return "edmx2idl";
    }

    @Override
    protected String getSourceType(Document edmx2idl) {
        return edmx2idl.getDocumentElement().getAttribute("sourceType");
    }

    @Override
    protected String getSourceKey() {
        return EDMX_DOCUMENT_SOURCE;
    }

    @Override
    protected String getImportSourcesKey() {
        return EDMX_IMPORT_MODELS;
    }

    @Override
    protected IDLImportSource createImportSource(String name, Element idlElement) {
        return new EDMXImportSource(name, idlElement, this.importsFolder, this.getHelpers());
    }
}

