/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Keys;
import ch.e2e.builder.compiler.build.types.logger.Param;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Params
extends RichElement {
    public static final String ELEMENT_NAME = "params";
    private Map<String, Param> params = new TreeMap<String, Param>();
    private Keys keys;

    public Params() {
    }

    public Params(Element tabfileElement) {
        super(tabfileElement);
        Iterator it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("param"));
        while (it.hasNext()) {
            Param incoming = new Param((Element)it.next());
            this.params.putIfAbsent(incoming.getAttributeValue("name"), incoming);
        }
        it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("keys"));
        while (it.hasNext()) {
            this.keys = new Keys((Element)it.next());
        }
    }

    public void merge(Params other) {
        this.params.putAll(other.params);
        if (this.keys != null) {
            this.keys.merge(other.keys);
        } else {
            this.keys = other.keys;
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.params.values());
        this.appendChild(this.keys);
    }

    public JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Param p : this.params.values()) {
            builder.add(p.getAttributeValue("name"), p.getAttributeValue("value"));
        }
        if (this.keys != null) {
            builder.add("keys", this.keys.buildJson());
        }
        return builder;
    }
}

