/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Sink;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Channel
extends RichElement {
    public static final String ELEMENT_NAME = "channel";
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("id");
        }
    };
    private Map<String, Sink> sinks = new LinkedHashMap<String, Sink>();

    public Channel() {
    }

    public Channel(Element tabfileElement) {
        super(tabfileElement);
        Iterator it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("sink"));
        while (it.hasNext()) {
            Sink incoming = new Sink((Element)it.next());
            this.sinks.putIfAbsent(incoming.getAttributeValue("name"), incoming);
        }
    }

    public void merge(Channel other) {
        for (Map.Entry<String, Sink> e : other.sinks.entrySet()) {
            Sink oldSink = this.sinks.get(e.getKey());
            if (oldSink != null) {
                oldSink.merge(e.getValue());
                continue;
            }
            this.sinks.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.sinks.values());
    }

    public JsonObjectBuilder buildJson() {
        JsonObjectBuilder sinksBuilder = Json.createObjectBuilder();
        for (Sink s : this.sinks.values()) {
            sinksBuilder.add(s.getAttributeValue("name"), s.buildJson());
        }
        return Json.createObjectBuilder().add("sinks", sinksBuilder);
    }
}

