/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.model;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlArtifact;
import ch.e2e.builder.compiler.models.EBMHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class AliasesXmiTransformationModelTask
extends XSLTTask {
    public static Boolean select(String id) {
        return id.equals(Files.model__aliases_xmiTransformationModel_xml);
    }

    public AliasesXmiTransformationModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._xml;
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.aliases";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        return AliasesXmiTransformationModelTask.getAliasesSourceSet(this.getSourceManager());
    }

    @Override
    protected Set<String> getSourceSet() {
        return AliasesXmiTransformationModelTask.getXumlAliasesSourceSet(this.getSourceManager());
    }

    public static Set<String> getAliasesSourceSet(SourceManager sourceManager) {
        HashSet<String> aliases = new HashSet<String>();
        Path projectPath = sourceManager.getProjectFolder().toPath();
        File aliasesFolder = new File(sourceManager.getProjectFolder(), Folders.aliases);
        if (aliasesFolder.isDirectory()) {
            for (File file : aliasesFolder.listFiles()) {
                if (file.isDirectory() || !file.getPath().endsWith(Extensions._artifact_json)) continue;
                aliases.add(projectPath.relativize(file.toPath()).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR).replace(Extensions._json, Extensions._xml));
            }
        }
        return aliases;
    }

    public static Set<String> getXumlAliasesSourceSet(SourceManager sourceManager) {
        HashSet<String> aliases = new HashSet<String>();
        Path projectPath = sourceManager.getProjectFolder().toPath();
        File aliasesFolder = new File(sourceManager.getProjectFolder(), Folders.aliases);
        if (aliasesFolder.isDirectory()) {
            for (File file : aliasesFolder.listFiles()) {
                String xmlSource;
                XumlArtifact artifact;
                if (file.isDirectory() || !file.getPath().endsWith(Extensions._artifact_json) || !(artifact = sourceManager.getSource(xmlSource = projectPath.relativize(file.toPath()).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR).replace(Extensions._json, Extensions._xml), JsonDocumentSource.class).getJsonDocument(XumlArtifact.class)).getAppliedStereotypes().stream().anyMatch(xumlAppliedStereotype -> EBMHelper.getStereotype((String)xumlAppliedStereotype.getStereotype()) != null)) continue;
                aliases.add(xmlSource);
            }
        }
        return aliases;
    }
}

