/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.control;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.control.CompileControlFactory;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.ActionScriptXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.ActivityXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.ClassXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.ExecutionXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.InterfaceXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.JavaScriptXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.MappingXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.PackageXmiPartTask;
import ch.e2e.builder.compiler.build.tasks.rest.RestTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class DurationAnalyzer {
    private final File workFolder;
    private final List<Task> tasks;

    public static void writeDurationLogs(SourceManager sourceManager, int compilationNumber) {
        if (CompileControlFactory.tracingEnabled()) {
            try {
                new DurationAnalyzer(sourceManager).writeDurationLogs(compilationNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DurationAnalyzer(SourceManager sourceManager) {
        this.workFolder = sourceManager.getWorkFolder();
        this.tasks = sourceManager.getTasks();
    }

    public void writeDurationLogs(int compilationNumber) throws IOException {
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("allTasks." + compilationNumber + Extensions._dat), this.tasks, "All Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("javaTasks." + compilationNumber + Extensions._dat), this.tasks.stream().filter(this::isJavaTask).collect(Collectors.toList()), "Java Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("xsltTasks." + compilationNumber + Extensions._dat), this.tasks.stream().filter(this::isXsltTask).collect(Collectors.toList()), "XSLT Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("xmiPartTasks." + compilationNumber + Extensions._dat), this.tasks.stream().filter(this::isXmiPartTask).collect(Collectors.toList()), "XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("packageXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof PackageXmiPartTask).collect(Collectors.toList()), "Package-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("classXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof ClassXmiPartTask).collect(Collectors.toList()), "Class-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("interfaceXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof InterfaceXmiPartTask).collect(Collectors.toList()), "Interface-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("executionXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof ExecutionXmiPartTask).collect(Collectors.toList()), "Execution-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("mappingXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof MappingXmiPartTask).collect(Collectors.toList()), "Mapping-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("actionScriptXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof ActionScriptXmiPartTask).collect(Collectors.toList()), "Action-Script-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("javaScriptXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof JavaScriptXmiPartTask).collect(Collectors.toList()), "Java-Script-XMI-Part Tasks");
        this.writeTaskGroupDurationsLogs(this.workFolder.toPath().resolve("activityXmiPart." + compilationNumber + Extensions._dat), this.tasks.stream().filter(task -> task instanceof ActivityXmiPartTask).collect(Collectors.toList()), "Activity-XMI-Part Tasks");
    }

    private void writeTaskGroupDurationsLogs(Path dataFile, List<Task> taskGroup, String taskGroupTitle) throws IOException {
        if (taskGroup.size() > 0) {
            this.writeDataFile(dataFile, taskGroup);
            this.writePlotFile(dataFile, taskGroup, taskGroupTitle);
        }
    }

    private void writeDataFile(Path dataFile, List<Task> taskGroup) throws IOException {
        Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
        if (Files.notExists(dataFile, new LinkOption[0])) {
            Files.createFile(dataFile, new FileAttribute[0]);
        }
        Files.write(dataFile, this.printDataTable(taskGroup).toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private StringBuilder printDataTable(List<Task> taskGroup) {
        taskGroup.sort((el1, el2) -> (int)(el1.getTaskInfo().getDuration() - el2.getTaskInfo().getDuration()));
        StringBuilder dataTable = new StringBuilder();
        for (int i = 1; i <= taskGroup.size(); ++i) {
            Task currentTask = taskGroup.get(i - 1);
            dataTable.append(i).append("\t").append(currentTask.getTaskInfo().getCacheInfo().getDuration()).append("\t").append(currentTask.getTaskInfo().getCacheInfo().getUpToDate()).append("\t").append(currentTask.getTaskInfo().getDuration()).append("\t").append(currentTask.getClass().getSimpleName()).append("\t").append(currentTask instanceof CacheAbleTask ? ((CacheAbleTask)currentTask).getId() : "").append("\t\n");
        }
        return dataTable;
    }

    private void writePlotFile(Path dataFile, List<Task> taskGroup, String taskGroupTitle) throws IOException {
        Path plotFile = dataFile.getParent().resolve(dataFile.getFileName().toString().replace(Extensions._dat, Extensions._plot));
        String outFileName = dataFile.getFileName().toString().replace(Extensions._dat, Extensions._png);
        Files.createDirectories(plotFile.getParent(), new FileAttribute[0]);
        if (Files.notExists(plotFile, new LinkOption[0])) {
            Files.createFile(plotFile, new FileAttribute[0]);
        }
        Long cacheTotal = taskGroup.stream().map(task -> task.getTaskInfo().getCacheInfo().getDuration()).reduce(0L, Long::sum);
        Long taskTotal = taskGroup.stream().map(task -> task.getTaskInfo().getDuration()).reduce(0L, Long::sum);
        double cacheRatio = (double)taskGroup.stream().filter(task -> task.getTaskInfo().getCacheInfo().getUpToDate()).count() / (double)taskGroup.size();
        int dataPointType = 7;
        String dataPointsColor = "'black'";
        StringBuilder plotFileContent = new StringBuilder().append("set terminal png\n").append("set output '" + outFileName + "'\n").append("set title '" + taskGroupTitle + "; Total: " + cacheTotal + " (caching) ms + " + taskTotal + " (executing) ms; CR: " + String.format("%.2f", cacheRatio * 100.0) + " %'\n").append("set xlabel '#'\n").append("set ylabel 'Time [ms]'\n").append("plot '" + dataFile.getFileName() + "' using 1:4 title '' with points pt " + dataPointType + " lt rgb " + dataPointsColor + "\n");
        Files.write(plotFile, plotFileContent.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private boolean isXsltTask(Task task) {
        return task instanceof XSLTTask;
    }

    private boolean isJavaTask(Task task) {
        return !this.isXsltTask(task);
    }

    private boolean isXmiPartTask(Task task) {
        return task instanceof PackageXmiPartTask || task instanceof ClassXmiPartTask || task instanceof InterfaceXmiPartTask || task instanceof ExecutionXmiPartTask || task instanceof MappingXmiPartTask || task instanceof ActionScriptXmiPartTask || task instanceof JavaScriptXmiPartTask || task instanceof ActivityXmiPartTask;
    }

    private boolean isRestTask(Task task) {
        return task instanceof RestTask;
    }
}

