/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SplitXmlDocumentUsingXpathTask
extends CacheAbleTask
implements XSLTTransformSource {
    public SplitXmlDocumentUsingXpathTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            XSLTTransformSource source = (XSLTTransformSource)this.getSource(this.getSourcePath());
            Node node = XSLTTransformSource.getNode(source.getXSLTTransformSource());
            Element model = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
            Node classNode = DomUtilities.selectNode((Node)model, (String)this.getSplitXpathExpression(), this.getNamespaces());
            if (Objects.nonNull(classNode)) {
                Path filePath = Paths.get(this.getSourceManager().getWorkFolder().getPath(), this.getId());
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Document newDocument = DomUtilities.newDocument();
                Node importedNode = newDocument.importNode(classNode, true);
                newDocument.appendChild(importedNode);
                DomUtilities.serialize((File)filePath.toFile(), (Document)newDocument, (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract String getSourcePath();

    protected abstract String getSplitXpathExpression();

    protected Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xuml", "http://scheer-group.com/xuml");
        return namespaces;
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new DOMSource(DomUtilities.parse((File)this.getDestinationFile(), (boolean)false, (boolean)false));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

