/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.InputList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class List
extends InputElement
implements InputFieldListener {
    private JScrollPane scrollPane;
    private InputList list;
    private ArrayList options = new ArrayList();
    private String icon;

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void updateIcon(String iconName) {
        if (this.icon == null || !this.icon.equals(iconName)) {
            this.icon = iconName;
            ImageIcon icon = ImageLoader.loadIcon((String)iconName, (boolean)true);
            ((DefaultListCellRenderer)this.list.getCellRenderer()).setIcon(icon);
        }
    }

    @Override
    public JComponent getGuiElement() {
        if (this.list == null) {
            this.list = new InputList((java.util.List)this.options);
            ArrayList<Option> selectedOptions = new ArrayList<Option>();
            int length = this.options.size();
            for (int i = 0; i < length; ++i) {
                Option option = (Option)this.options.get(i);
                if (!option.selected) continue;
                selectedOptions.add(option);
            }
            this.list.setContent(selectedOptions);
            this.list.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List.this.fireAction(e);
                }
            });
            DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            this.list.setCellRenderer((ListCellRenderer)renderer);
            if (this.icon != null) {
                renderer.setIcon(ImageLoader.loadIcon((String)this.icon, (boolean)true));
            }
            this.list.addInputFieldListener((InputFieldListener)this);
            this.scrollPane = new JScrollPane((Component)this.list);
        }
        return this.scrollPane;
    }

    @Override
    public String getValue() {
        String result = null;
        if (this.list.isEnabled()) {
            Object[] selectedValues = this.list.getSelectedValues();
            StringBuffer resultBuffer = new StringBuffer();
            for (int i = 0; i < selectedValues.length; ++i) {
                Object value = selectedValues[i];
                if (resultBuffer.length() == 0) {
                    resultBuffer.append(value);
                    continue;
                }
                resultBuffer.append(" ").append(value);
            }
            result = resultBuffer.length() == 0 ? null : resultBuffer.toString();
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.list.requestFocus();
    }

    public void inputFieldChanged(InputFieldEvent event) {
        this.fireInputFieldChanged(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Object[] selectedValues;
        this.list.setEnabled(enabled);
        if (enabled && (selectedValues = this.list.getSelectedValues()).length == 0 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public class Option {
        private String value;
        private boolean selected;

        public void setValue(String value) {
            this.value = value;
        }

        public void updateValue(String value) {
            this.setValue(value);
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void updateSelect(boolean selected) {
            this.setSelected(selected);
        }

        public String toString() {
            return this.value;
        }
    }
}

