/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.models;

import ch.e2e.builder.compiler.models.E2EBridgeModelGenerator;
import ch.e2e.builder.compiler.models.EBMAppliedStereotype;
import ch.e2e.builder.compiler.models.EBMElement;
import ch.e2e.builder.compiler.models.EBMElementInterface;
import ch.e2e.builder.compiler.models.EBMGeneralization;
import ch.e2e.builder.compiler.models.EBMModels;
import ch.e2e.builder.compiler.models.EBMProperty;
import ch.e2e.builder.compiler.models.EBMStereotype;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EBMHelper {
    private static Document modelsDoc;
    private static EBMModels ebmModels;
    private static Map<String, EBMElement> elements;
    private static final Map<String, EBMStereotype> stereotypes;
    private static Map<String, List<EBMGeneralization>> generalizationsMap;

    private static Document getModelsDoc() {
        if (modelsDoc == null) {
            try {
                modelsDoc = E2EBridgeModelGenerator.collectModels();
            }
            catch (Exception ignore) {
                boolean bl = false;
            }
        }
        return modelsDoc;
    }

    public static EBMModels getModels() {
        if (ebmModels == null) {
            try {
                JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{EBMModels.class}, new HashMap());
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                ebmModels = (EBMModels)jaxbUnmarshaller.unmarshal((Node)EBMHelper.getModelsDoc(), EBMModels.class).getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ebmModels;
    }

    static void putElement(EBMElement ebmElement) {
        elements.put(ebmElement.getEbmId(), ebmElement);
    }

    public static EBMElement getElement(String key) {
        EBMHelper.getModels();
        if (key.startsWith("ebm:")) {
            key = key.substring("ebm:".length());
        }
        return elements.get(key);
    }

    public static <T> T getElement(String key, Class<T> type) {
        EBMElement element;
        EBMHelper.getModels();
        if (key.startsWith("ebm:")) {
            key = key.substring("ebm:".length());
        }
        if (type.isAssignableFrom((element = elements.get(key)).getClass())) {
            return (T)element;
        }
        return null;
    }

    static void putStereotype(EBMStereotype ebmElement) {
        stereotypes.put(ebmElement.getName(), ebmElement);
    }

    public static EBMStereotype getStereotype(String key) {
        EBMHelper.getModels();
        EBMElement element = EBMHelper.getElement(key);
        if (element instanceof EBMStereotype) {
            return (EBMStereotype)element;
        }
        return stereotypes.get(key);
    }

    public static List<EBMStereotype> getStereotypes(EBMElement ebmElement) {
        ArrayList<EBMStereotype> stereotypes = new ArrayList<EBMStereotype>();
        for (EBMAppliedStereotype appliedStereotype : ebmElement.getAppliedStereotypes()) {
            EBMStereotype ebmStereotype = EBMHelper.getStereotype(appliedStereotype.getStereotype());
            if (ebmStereotype == null) continue;
            stereotypes.add(ebmStereotype);
        }
        return stereotypes;
    }

    public static Boolean hasStereotype(EBMElement ebmElement, EBMStereotype stereotype) {
        for (EBMAppliedStereotype appliedStereotype : ebmElement.getAppliedStereotypes()) {
            EBMStereotype ebmStereotype = EBMHelper.getStereotype(appliedStereotype.getStereotype());
            if (ebmStereotype != stereotype) continue;
            return true;
        }
        return false;
    }

    public static Object getStereotypePropertyFirst(EBMElement ebmElement, EBMStereotype ebmStereotype, String tag) {
        for (EBMAppliedStereotype appliedStereotype : ebmElement.getAppliedStereotypes()) {
            EBMStereotype stereotype = EBMHelper.getStereotype(appliedStereotype.getStereotype());
            if (stereotype != ebmStereotype) continue;
            return appliedStereotype.getPropertyFirst(tag);
        }
        return null;
    }

    public static List<Object> getStereotypeProperty(EBMElementInterface ebmElement, EBMStereotype ebmStereotype, String tag) {
        for (EBMAppliedStereotype appliedStereotype : ebmElement.getAppliedStereotypes()) {
            EBMStereotype stereotype = EBMHelper.getStereotype(appliedStereotype.getStereotype());
            if (stereotype != ebmStereotype) continue;
            return appliedStereotype.getProperty(tag);
        }
        return null;
    }

    public static Map<EBMStereotype, List<EBMProperty>> getPropertiesIncludingParents(EBMStereotype ebmStereotype) {
        HashMap<EBMStereotype, List<EBMProperty>> result = new HashMap<EBMStereotype, List<EBMProperty>>();
        result.put(ebmStereotype, ebmStereotype.getProperties());
        for (EBMGeneralization generalization : ebmStereotype.getGeneralizations()) {
            EBMStereotype parent;
            String parentKey = generalization.getGeneralKey();
            if (parentKey == null || (parent = EBMHelper.getStereotype(parentKey)) == null) continue;
            result.putAll(EBMHelper.getPropertiesIncludingParents(parent));
        }
        return result;
    }

    static void addGeneralization(EBMGeneralization generalization) {
        String key = generalization.getGeneralKey();
        if (key != null) {
            List<EBMGeneralization> generalizationList = generalizationsMap.get(key);
            if (generalizationList == null) {
                generalizationList = new ArrayList<EBMGeneralization>();
                generalizationsMap.put(key, generalizationList);
            }
            generalizationList.add(generalization);
        }
    }

    public static List<EBMGeneralization> getGeneralizationsOf(EBMElement ebmElement) {
        List<EBMGeneralization> list = generalizationsMap.get("ebm:" + ebmElement.getEbmId());
        if (list != null) {
            return list;
        }
        return new ArrayList<EBMGeneralization>();
    }

    public static EBMElement getGeneralizationGeneral(EBMGeneralization ebmGeneralization) {
        String key = ebmGeneralization.getGeneralKey();
        if (key != null) {
            return EBMHelper.getElement(key);
        }
        return null;
    }

    static {
        elements = new HashMap<String, EBMElement>();
        stereotypes = new HashMap<String, EBMStereotype>();
        generalizationsMap = new HashMap<String, List<EBMGeneralization>>();
    }
}

